/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import java.util.HashMap;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshotter;
import org.gradle.api.internal.initialization.loadercache.DefaultClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.FileClassPathSnapshotter;
import org.gradle.api.internal.initialization.loadercache.HashClassPathSnapshotter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ClassLoaderCacheFactory {
    public static final String TOGGLE_CACHING_PROPERTY = "org.gradle.caching.classloaders";
    private static final Logger LOGGER = Logging.getLogger(ClassLoaderCacheFactory.class);
    private DefaultClassLoaderCache instance;

    public ClassLoaderCache create() {
        if ("true".equalsIgnoreCase(System.getProperty(TOGGLE_CACHING_PROPERTY))) {
            this.maybeInit();
            return this.instance;
        }
        return this.newCache(new FileClassPathSnapshotter());
    }

    private DefaultClassLoaderCache newCache(ClassPathSnapshotter snapshotter) {
        return new DefaultClassLoaderCache(new HashMap<DefaultClassLoaderCache.Key, ClassLoader>(), snapshotter);
    }

    private void maybeInit() {
        if (this.instance == null) {
            this.instance = this.newCache(new HashClassPathSnapshotter());
            LOGGER.lifecycle("Initialized global ClassLoader cache.");
        }
    }
}

