/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.DefaultClassLoaderScope;
import org.gradle.api.internal.initialization.ScopeNodeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootClassLoaderScope
implements ClassLoaderScope {
    private final ClassLoader localClassLoader;
    private final ClassLoader exportClassLoader;
    private final ClassLoaderCache classLoaderCache;
    private final ScopeNodeIdentifier id;

    public RootClassLoaderScope(ClassLoader localClassLoader, ClassLoader exportClassLoader, ClassLoaderCache classLoaderCache) {
        this.localClassLoader = localClassLoader;
        this.exportClassLoader = exportClassLoader;
        this.classLoaderCache = classLoaderCache;
        this.id = new ScopeNodeIdentifier("root", (IdGenerator<Long>)new LongIdGenerator());
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        return this.localClassLoader;
    }

    @Override
    public ClassLoader getExportClassLoader() {
        return this.exportClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        return this.localClassLoader.equals(clazz.getClassLoader()) || this.exportClassLoader.equals(clazz.getClassLoader());
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        throw new UnsupportedOperationException("root class loader scope is immutable");
    }

    @Override
    public ClassLoaderScope createChild() {
        return new DefaultClassLoaderScope(this.id.newChild(), this, this.classLoaderCache);
    }

    @Override
    public ClassLoaderScope lock() {
        return this;
    }

    @Override
    public boolean isLocked() {
        return true;
    }
}

