/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.DefaultPluginCollection;
import org.gradle.api.internal.plugins.PluginApplication;
import org.gradle.api.internal.plugins.PluginApplicationAction;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginContainer<T extends PluginAware>
extends DefaultPluginCollection<Plugin>
implements PluginContainer {
    private PluginRegistry pluginRegistry;
    private final LoadingCache<IdLookupCacheKey, Boolean> idLookupCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IdLookupCacheKey, Boolean>(){

        public Boolean load(IdLookupCacheKey key) throws Exception {
            Class pluginClass = key.pluginClass;
            try {
                Class<Plugin<?>> typeForId = DefaultPluginContainer.this.pluginRegistry.getTypeForId(key.id);
                if (typeForId.equals(pluginClass)) {
                    return true;
                }
            }
            catch (UnknownPluginException ignore) {
                // empty catch block
            }
            ClassloaderBackedPluginDescriptorLocator locator = new ClassloaderBackedPluginDescriptorLocator(pluginClass.getClassLoader());
            PluginDescriptor pluginDescriptor = locator.findPluginDescriptor(key.id);
            return pluginDescriptor != null && pluginDescriptor.getImplementationClassName().equals(pluginClass.getName());
        }
    });
    private final T pluginAware;
    private final List<PluginApplicationAction> pluginApplicationActions;

    public DefaultPluginContainer(PluginRegistry pluginRegistry, T pluginAware) {
        this(pluginRegistry, pluginAware, Collections.emptyList());
    }

    public DefaultPluginContainer(PluginRegistry pluginRegistry, T pluginAware, List<PluginApplicationAction> pluginApplicationActions) {
        super(Plugin.class);
        this.pluginRegistry = pluginRegistry;
        this.pluginAware = pluginAware;
        this.pluginApplicationActions = pluginApplicationActions;
    }

    @Override
    public Plugin apply(String id) {
        return this.addPluginInternal(this.getTypeForId(id));
    }

    public <P extends Plugin> P apply(Class<P> type) {
        return this.addPluginInternal(type);
    }

    @Override
    public boolean hasPlugin(String id) {
        return this.findPlugin(id) != null;
    }

    @Override
    public boolean hasPlugin(Class<? extends Plugin> type) {
        return this.findPlugin((Class)type) != null;
    }

    @Override
    public Plugin findPlugin(String id) {
        try {
            return this.findPlugin((Class)this.getTypeForId(id));
        }
        catch (UnknownPluginException e) {
            return null;
        }
    }

    public <P extends Plugin> P findPlugin(Class<P> type) {
        for (Plugin plugin : this) {
            if (!plugin.getClass().equals(type)) continue;
            return (P)((Plugin)type.cast(plugin));
        }
        return null;
    }

    private <P extends Plugin<?>> P addPluginInternal(Class<P> type) {
        if (this.findPlugin(type) == null) {
            Plugin<T> plugin = this.providePlugin(type);
            for (PluginApplicationAction onApplyAction : this.pluginApplicationActions) {
                onApplyAction.execute(new PluginApplication(plugin, (PluginAware)this.pluginAware));
            }
            this.add(plugin);
        }
        return (P)((Plugin)type.cast(this.findPlugin(type)));
    }

    @Override
    public Plugin getPlugin(String id) {
        Plugin plugin = this.findPlugin(id);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id " + id + " has not been used.");
        }
        return plugin;
    }

    @Override
    public Plugin getAt(String id) throws UnknownPluginException {
        return this.getPlugin(id);
    }

    public <P extends Plugin> P getAt(Class<P> type) throws UnknownPluginException {
        return this.getPlugin(type);
    }

    public <P extends Plugin> P getPlugin(Class<P> type) throws UnknownPluginException {
        P plugin = this.findPlugin(type);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with type " + type + " has not been used.");
        }
        return (P)((Plugin)type.cast(plugin));
    }

    @Override
    public void withId(final String pluginId, Action<? super Plugin> action) {
        this.matching((Spec)new Spec<Plugin>(){

            public boolean isSatisfiedBy(Plugin element) {
                try {
                    return (Boolean)DefaultPluginContainer.this.idLookupCache.get((Object)new IdLookupCacheKey(element.getClass(), pluginId));
                }
                catch (ExecutionException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }).all(action);
    }

    protected Class<? extends Plugin> getTypeForId(String id) {
        return this.pluginRegistry.getTypeForId(id);
    }

    private Plugin<T> providePlugin(Class<? extends Plugin<?>> type) {
        Plugin<?> plugin = this.pluginRegistry.loadPlugin(type);
        plugin.apply(this.pluginAware);
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdLookupCacheKey {
        private final Class<?> pluginClass;
        private final String id;

        private IdLookupCacheKey(Class<?> pluginClass, String id) {
            this.pluginClass = pluginClass;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdLookupCacheKey that = (IdLookupCacheKey)o;
            return this.id.equals(that.id) && this.pluginClass.equals(that.pluginClass);
        }

        public int hashCode() {
            int result = this.pluginClass.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }
}

