/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingDeprecatedFeatureHandler
implements DeprecatedFeatureHandler {
    private static final Logger LOGGER = Logging.getLogger(LoggingDeprecatedFeatureHandler.class);
    private final Set<String> messages = new HashSet<String>();
    private UsageLocationReporter locationReporter;

    public LoggingDeprecatedFeatureHandler() {
        this(new UsageLocationReporter(){

            public void reportLocation(DeprecatedFeatureUsage usage, StringBuilder target) {
            }
        });
    }

    public LoggingDeprecatedFeatureHandler(UsageLocationReporter locationReporter) {
        this.locationReporter = locationReporter;
    }

    public void setLocationReporter(UsageLocationReporter locationReporter) {
        this.locationReporter = locationReporter;
    }

    @Override
    public void deprecatedFeatureUsed(DeprecatedFeatureUsage usage) {
        if (this.messages.add(usage.getMessage())) {
            usage = usage.withStackTrace();
            StringBuilder message = new StringBuilder();
            this.locationReporter.reportLocation(usage, message);
            if (message.length() > 0) {
                message.append(SystemProperties.getLineSeparator());
            }
            message.append(usage.getMessage());
            this.logTraceIfNecessary(usage.getStack(), message);
            LOGGER.warn(message.toString());
        }
    }

    private void logTraceIfNecessary(List<StackTraceElement> stack, StringBuilder message) {
        if (LoggingDeprecatedFeatureHandler.isTraceLoggingEnabled()) {
            for (StackTraceElement frame : stack) {
                message.append(SystemProperties.getLineSeparator());
                message.append("    ");
                message.append(frame.toString());
            }
        }
    }

    private static boolean isTraceLoggingEnabled() {
        return Boolean.getBoolean("org.gradle.deprecation.trace");
    }
}

