/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRegistry
implements PluginRegistry {
    private final Map<String, Class<? extends Plugin<?>>> idMappings = new HashMap();
    private final DefaultPluginRegistry parent;
    private final Factory<? extends ClassLoader> classLoaderFactory;
    private final Instantiator instantiator;

    public DefaultPluginRegistry(ClassLoader classLoader, Instantiator instantiator) {
        this((Factory<? extends ClassLoader>)Factories.constant((Object)classLoader), instantiator);
    }

    public DefaultPluginRegistry(Factory<? extends ClassLoader> classLoaderFactory, Instantiator instantiator) {
        this(null, classLoaderFactory, instantiator);
    }

    private DefaultPluginRegistry(DefaultPluginRegistry parent, Factory<? extends ClassLoader> classLoaderFactory, Instantiator instantiator) {
        this.parent = parent;
        this.classLoaderFactory = classLoaderFactory;
        this.instantiator = instantiator;
    }

    @Override
    public PluginRegistry createChild(final ClassLoaderScope lookupScope, Instantiator instantiator) {
        Factory<ClassLoader> classLoaderFactory = new Factory<ClassLoader>(){

            public ClassLoader create() {
                return lookupScope.getLocalClassLoader();
            }
        };
        return new DefaultPluginRegistry(this, (Factory<? extends ClassLoader>)classLoaderFactory, instantiator);
    }

    @Override
    public <T extends Plugin<?>> T loadPlugin(Class<T> pluginClass) {
        if (!Plugin.class.isAssignableFrom(pluginClass)) {
            throw new InvalidUserDataException(String.format("Cannot create plugin of type '%s' as it does not implement the Plugin interface.", pluginClass.getSimpleName()));
        }
        try {
            return (T)((Plugin)this.instantiator.newInstance(pluginClass, new Object[0]));
        }
        catch (ObjectInstantiationException e) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", pluginClass.getSimpleName()), e.getCause());
        }
    }

    @Override
    public Class<? extends Plugin<?>> getTypeForId(String pluginId) {
        Class<Plugin<Object>> implClass;
        if (this.parent != null) {
            try {
                return this.parent.getTypeForId(pluginId);
            }
            catch (UnknownPluginException e) {
                // empty catch block
            }
        }
        if ((implClass = this.idMappings.get(pluginId)) != null) {
            return implClass;
        }
        ClassLoader classLoader = (ClassLoader)this.classLoaderFactory.create();
        PluginDescriptor pluginDescriptor = this.findPluginDescriptor(pluginId, classLoader);
        if (pluginDescriptor == null) {
            throw new UnknownPluginException("Plugin with id '" + pluginId + "' not found.");
        }
        String implClassName = pluginDescriptor.getImplementationClassName();
        if (!GUtil.isTrue(implClassName)) {
            throw new PluginInstantiationException(String.format("No implementation class specified for plugin '%s' in %s.", pluginId, pluginDescriptor));
        }
        try {
            Class<?> rawClass = classLoader.loadClass(implClassName);
            if (!Plugin.class.isAssignableFrom(rawClass)) {
                throw new PluginInstantiationException(String.format("Implementation class '%s' specified for plugin '%s' does not implement the Plugin interface. Specified in %s.", implClassName, pluginId, pluginDescriptor));
            }
            Class<Plugin> cast = rawClass.asSubclass(Plugin.class);
            implClass = cast;
        }
        catch (ClassNotFoundException e) {
            throw new PluginInstantiationException(String.format("Could not find implementation class '%s' for plugin '%s' specified in %s.", implClassName, pluginId, pluginDescriptor), e);
        }
        this.idMappings.put(pluginId, implClass);
        return implClass;
    }

    protected PluginDescriptor findPluginDescriptor(String pluginId, ClassLoader classLoader) {
        ClassloaderBackedPluginDescriptorLocator pluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(classLoader);
        return pluginDescriptorLocator.findPluginDescriptor(pluginId);
    }
}

