/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTaskArtifactCache
implements CacheDecorator {
    private static final Logger LOG = Logging.getLogger(InMemoryTaskArtifactCache.class);
    private static final Object NULL = new Object();
    private static final Map<String, Integer> CACHE_CAPS = new HashMap<String, Integer>();
    private final Object lock = new Object();
    private final Cache<String, Cache<Object, Object>> cache = CacheBuilder.newBuilder().maximumSize((long)(CACHE_CAPS.size() * 2)).build();
    private final Map<String, FileLock.State> states = new HashMap<String, FileLock.State>();

    @Override
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> decorate(final String cacheId, String cacheName, final MultiProcessSafePersistentIndexedCache<K, V> original) {
        final Cache<Object, Object> data = this.loadData(cacheId, cacheName);
        return new MultiProcessSafePersistentIndexedCache<K, V>(){

            @Override
            public void close() {
                original.close();
            }

            @Override
            public V get(K key) {
                assert (key instanceof String || key instanceof Long || key instanceof File) : "Unsupported key type: " + key;
                Object value = data.getIfPresent(key);
                if (value == NULL) {
                    return null;
                }
                if (value != null) {
                    return value;
                }
                Object out = original.get(key);
                data.put(key, out == null ? NULL : out);
                return out;
            }

            @Override
            public void put(K key, V value) {
                original.put(key, value);
                data.put(key, value);
            }

            @Override
            public void remove(K key) {
                data.put(key, NULL);
                original.remove(key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartWork(String operationDisplayName, FileLock.State currentCacheState) {
                boolean outOfDate;
                Object object = InMemoryTaskArtifactCache.this.lock;
                synchronized (object) {
                    FileLock.State previousState = (FileLock.State)InMemoryTaskArtifactCache.this.states.get(cacheId);
                    outOfDate = previousState == null || currentCacheState.hasBeenUpdatedSince(previousState);
                }
                if (outOfDate) {
                    LOG.info("Invalidating in-memory cache of {}", cacheId);
                    data.invalidateAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEndWork(FileLock.State currentCacheState) {
                Object object = InMemoryTaskArtifactCache.this.lock;
                synchronized (object) {
                    InMemoryTaskArtifactCache.this.states.put(cacheId, currentCacheState);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<Object, Object> loadData(String cacheId, String cacheName) {
        Cache theData;
        Object object = this.lock;
        synchronized (object) {
            theData = (Cache)this.cache.getIfPresent((Object)cacheId);
            if (theData != null) {
                LOG.info("In-memory cache of {}: Size{{}}, {}", cacheId, theData.size(), theData.stats());
            } else {
                Integer maxSize = CACHE_CAPS.get(cacheName);
                assert (maxSize != null) : "Unknown cache.";
                theData = CacheBuilder.newBuilder().maximumSize((long)maxSize.intValue()).build();
                this.cache.put((Object)cacheId, (Object)theData);
            }
        }
        return theData;
    }

    static {
        CACHE_CAPS.put("fileSnapshots", 10000);
        CACHE_CAPS.put("taskArtifacts", 2000);
        CACHE_CAPS.put("outputFileStates", 3000);
        CACHE_CAPS.put("fileHashes", 140000);
        CACHE_CAPS.put("compilationState", 1000);
    }
}

