/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.api.internal.coerce.TypeCoercingMethodArgumentsTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDynamicObject
extends AbstractDynamicObject {
    private final Object bean;
    private final boolean includeProperties;
    private final DynamicObject delegate;
    private final boolean implementsMissing;
    private final MethodArgumentsTransformer argsTransformer = new TypeCoercingMethodArgumentsTransformer();

    public BeanDynamicObject(Object bean) {
        this(bean, true);
    }

    private BeanDynamicObject(Object bean, boolean includeProperties) {
        this(bean, includeProperties, true);
    }

    private BeanDynamicObject(Object bean, boolean includeProperties, boolean implementsMissing) {
        this.bean = bean;
        this.includeProperties = includeProperties;
        this.implementsMissing = implementsMissing;
        this.delegate = this.determineDelegate(bean);
    }

    public DynamicObject determineDelegate(Object bean) {
        if (bean instanceof DynamicObject || bean instanceof DynamicObjectAware || !(bean instanceof GroovyObject)) {
            return new MetaClassAdapter();
        }
        return new GroovyObjectAdapter();
    }

    public BeanDynamicObject withNoProperties() {
        return new BeanDynamicObject(this.bean, false);
    }

    public BeanDynamicObject withNotImplementsMissing() {
        return new BeanDynamicObject(this.bean, this.includeProperties, false);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    protected String getDisplayName() {
        return this.bean.toString();
    }

    private MetaClass getMetaClass() {
        if (this.bean instanceof GroovyObject) {
            return ((GroovyObject)this.bean).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.bean.getClass());
    }

    @Override
    public boolean isMayImplementMissingMethods() {
        return this.implementsMissing && this.delegate.isMayImplementMissingMethods();
    }

    @Override
    public boolean isMayImplementMissingProperties() {
        return this.implementsMissing && this.includeProperties && this.delegate.isMayImplementMissingProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.delegate.hasProperty(name);
    }

    @Override
    public Object getProperty(String name) throws MissingPropertyException {
        return this.delegate.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws MissingPropertyException {
        this.delegate.setProperty(name, value);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        return this.delegate.hasMethod(name, arguments);
    }

    @Override
    public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
        arguments = this.argsTransformer.transform(this.bean, name, arguments);
        return this.delegate.invokeMethod(name, arguments);
    }

    private class GroovyObjectAdapter
    extends MetaClassAdapter {
        private final GroovyObject groovyObject;

        private GroovyObjectAdapter() {
            this.groovyObject = (GroovyObject)BeanDynamicObject.this.bean;
        }

        public Object getProperty(String name) throws MissingPropertyException {
            return this.groovyObject.getProperty(name);
        }

        public void setProperty(String name, Object value) throws MissingPropertyException {
            this.groovyObject.setProperty(name, value);
        }

        public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
            try {
                return this.groovyObject.invokeMethod(name, (Object)arguments);
            }
            catch (InvokerInvocationException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetaClassAdapter
    implements DynamicObject {
        private MetaClassAdapter() {
        }

        @Override
        public boolean hasProperty(String name) {
            return BeanDynamicObject.this.includeProperties && BeanDynamicObject.this.getMetaClass().hasProperty(BeanDynamicObject.this.bean, name) != null;
        }

        @Override
        public Object getProperty(String name) throws MissingPropertyException {
            if (!BeanDynamicObject.this.includeProperties) {
                throw BeanDynamicObject.this.propertyMissingException(name);
            }
            MetaProperty property = BeanDynamicObject.this.getMetaClass().hasProperty(BeanDynamicObject.this.bean, name);
            if (property == null) {
                return BeanDynamicObject.this.getMetaClass().invokeMissingProperty(BeanDynamicObject.this.bean, name, null, true);
            }
            if (property instanceof MetaBeanProperty && ((MetaBeanProperty)property).getGetter() == null) {
                throw new GroovyRuntimeException(String.format("Cannot get the value of write-only property '%s' on %s.", name, BeanDynamicObject.this.getDisplayName()));
            }
            try {
                return property.getProperty(BeanDynamicObject.this.bean);
            }
            catch (InvokerInvocationException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void setProperty(final String name, Object value) throws MissingPropertyException {
            if (!BeanDynamicObject.this.includeProperties) {
                throw BeanDynamicObject.this.propertyMissingException(name);
            }
            MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
            MetaProperty property = metaClass.hasProperty(BeanDynamicObject.this.bean, name);
            if (property == null) {
                BeanDynamicObject.this.getMetaClass().invokeMissingProperty(BeanDynamicObject.this.bean, name, null, false);
            }
            if (property instanceof MetaBeanProperty && ((MetaBeanProperty)property).getSetter() == null) {
                throw new ReadOnlyPropertyException(name, BeanDynamicObject.this.bean.getClass()){

                    public String getMessage() {
                        return String.format("Cannot set the value of read-only property '%s' on %s.", name, BeanDynamicObject.this.getDisplayName());
                    }
                };
            }
            try {
                value = BeanDynamicObject.this.argsTransformer.transform(BeanDynamicObject.this.bean, MetaProperty.getSetterName((String)name), value)[0];
                metaClass.setProperty(BeanDynamicObject.this.bean, name, value);
            }
            catch (InvokerInvocationException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public Map<String, ?> getProperties() {
            if (!BeanDynamicObject.this.includeProperties) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            List classProperties = BeanDynamicObject.this.getMetaClass().getProperties();
            for (MetaProperty metaProperty : classProperties) {
                MetaBeanProperty beanProperty;
                if (metaProperty.getName().equals("properties")) {
                    properties.put("properties", properties);
                    continue;
                }
                if (metaProperty instanceof MetaBeanProperty && (beanProperty = (MetaBeanProperty)metaProperty).getGetter() == null) continue;
                properties.put(metaProperty.getName(), metaProperty.getProperty(BeanDynamicObject.this.bean));
            }
            return properties;
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return !BeanDynamicObject.this.getMetaClass().respondsTo(BeanDynamicObject.this.bean, name, arguments).isEmpty();
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
            try {
                return BeanDynamicObject.this.getMetaClass().invokeMethod(BeanDynamicObject.this.bean, name, arguments);
            }
            catch (InvokerInvocationException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public boolean isMayImplementMissingMethods() {
            return true;
        }

        @Override
        public boolean isMayImplementMissingProperties() {
            return true;
        }
    }
}

