/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginRequest;
import org.gradle.plugin.use.internal.DefaultPluginRequests;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.internal.PluginRequests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRequestsSerializer
implements Serializer<PluginRequests> {
    public PluginRequests read(Decoder decoder) throws Exception {
        int requestCount = decoder.readSmallInt();
        ArrayList requests = Lists.newArrayListWithCapacity((int)requestCount);
        for (int i = 0; i < requestCount; ++i) {
            PluginId pluginId = PluginId.unvalidated(decoder.readString());
            String version = decoder.readNullableString();
            int lineNumber = decoder.readSmallInt();
            String scriptDisplayName = decoder.readString();
            requests.add(i, new DefaultPluginRequest(pluginId, version, lineNumber, scriptDisplayName));
        }
        return new DefaultPluginRequests(requests);
    }

    public void write(Encoder encoder, PluginRequests requests) throws Exception {
        encoder.writeSmallInt(requests.size());
        for (PluginRequest request : requests) {
            encoder.writeString((CharSequence)request.getId().asString());
            encoder.writeNullableString((CharSequence)request.getVersion());
            encoder.writeSmallInt(request.getLineNumber());
            encoder.writeString((CharSequence)request.getScriptDisplayName());
        }
    }
}

