/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static Logger logger = Logging.getLogger(ExecuteActionsTaskExecuter.class);
    private final TaskActionListener listener;

    public ExecuteActionsTaskExecuter(TaskActionListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        this.listener.beforeActions(task);
        state.setExecuting(true);
        try {
            GradleException failure = this.executeActions(task, state, context);
            state.executed(failure);
        }
        finally {
            state.setExecuting(false);
            this.listener.afterActions(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleException executeActions(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        logger.debug("Executing actions for {}.", task);
        ArrayList<ContextAwareTaskAction> actions = new ArrayList<ContextAwareTaskAction>(task.getTaskActions());
        for (ContextAwareTaskAction action : actions) {
            state.setDidWork(true);
            task.getStandardOutputCapture().start();
            try {
                this.executeAction(task, action, context);
            }
            catch (StopActionException e) {
                logger.debug("Action stopped by some action with message: {}", e.getMessage());
            }
            catch (StopExecutionException e) {
                logger.info("Execution stopped by some action with message: {}", e.getMessage());
                break;
            }
            catch (Throwable t) {
                TaskExecutionException taskExecutionException = new TaskExecutionException(task, t);
                return taskExecutionException;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(TaskInternal task, ContextAwareTaskAction action, TaskExecutionContext context) {
        action.contextualise(context);
        try {
            action.execute(task);
        }
        finally {
            action.contextualise(null);
        }
    }
}

