/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import com.google.common.collect.Maps;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicPropertyNamer;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.FactoryNamedDomainObjectContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.DeferredProjectConfiguration;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Actions;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.model.Model;
import org.gradle.model.RuleSource;
import org.gradle.model.dsl.internal.NonTransformedModelDslBacking;
import org.gradle.model.dsl.internal.TransformedModelDslBacking;
import org.gradle.model.internal.core.DefaultNodeInitializerRegistry;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProject
extends AbstractPluginAware
implements ProjectInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Project.class);
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private ServiceRegistry services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private ProjectEvaluator projectEvaluator;
    private ScriptSource buildScriptSource;
    private final File projectDir;
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Object status;
    private final Map<String, Project> childProjects = Maps.newTreeMap();
    private List<String> defaultTasks = new ArrayList<String>();
    private ProjectStateInternal state;
    private FileResolver fileResolver;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private Object buildDir = "build";
    private final int depth;
    private TaskContainerInternal taskContainer;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainer configurationContainer;
    private ArtifactHandler artifactHandler;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = new ListenerBroadcast(ProjectEvaluationListener.class);
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private final Path path;

    public AbstractProject(String name, ProjectInternal parent, File projectDir, ScriptSource buildScriptSource, GradleInternal gradle, ServiceRegistryFactory serviceRegistryFactory, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        this.classLoaderScope = selfClassLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        assert (name != null);
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        if (parent == null) {
            this.path = Path.ROOT;
            this.depth = 0;
        } else {
            String path = parent.absoluteProjectPath(name);
            this.depth = parent.getDepth() + 1;
            this.path = Path.path(path);
        }
        this.services = serviceRegistryFactory.createFor(this);
        this.taskContainer = (TaskContainerInternal)this.services.newInstance(TaskContainerInternal.class);
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.services.get(Instantiator.class));
        if (parent != null) {
            this.extensibleDynamicObject.setParent(parent.getInheritedScope());
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add((Object)gradle.getProjectEvaluationBroadcaster());
        this.populateModelRegistry((ModelRegistry)this.services.get(ModelRegistry.class));
    }

    private void populateModelRegistry(ModelRegistry modelRegistry) {
        this.registerServiceOn(modelRegistry, "serviceRegistry", ServiceRegistry.class, this.services, this.instanceDescriptorFor("serviceRegistry"));
        this.registerFactoryOn(modelRegistry, "buildDir", File.class, new Factory<File>(){

            public File create() {
                return AbstractProject.this.getBuildDir();
            }
        });
        this.registerInstanceOn(modelRegistry, "projectIdentifier", ProjectIdentifier.class, this);
        this.registerInstanceOn(modelRegistry, "extensionContainer", ExtensionContainer.class, this.getExtensions());
        modelRegistry.getRoot().applyToSelf(BasicServicesRules.class);
    }

    private <T> void registerInstanceOn(ModelRegistry modelRegistry, String path, Class<T> type, T instance) {
        this.registerFactoryOn(modelRegistry, path, type, Factories.constant(instance));
    }

    private <T> void registerFactoryOn(ModelRegistry modelRegistry, String path, Class<T> type, Factory<T> factory) {
        modelRegistry.register(ModelRegistrations.unmanagedInstance((ModelReference)ModelReference.of((String)path, type), factory).descriptor(this.instanceDescriptorFor(path)).hidden(true).build());
    }

    private <T> void registerServiceOn(ModelRegistry modelRegistry, String path, Class<T> type, T instance, String descriptor) {
        modelRegistry.register(ModelRegistrations.serviceInstance((ModelReference)ModelReference.of((String)path, type), instance).descriptor(descriptor).build());
    }

    private String instanceDescriptorFor(String path) {
        return "Project.<init>." + path + "()";
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.rootProject;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    public ProjectEvaluator getProjectEvaluator() {
        if (this.projectEvaluator == null) {
            this.projectEvaluator = (ProjectEvaluator)this.services.get(ProjectEvaluator.class);
        }
        return this.projectEvaluator;
    }

    public void setProjectEvaluator(ProjectEvaluator projectEvaluator) {
        this.projectEvaluator = projectEvaluator;
    }

    @Override
    @Inject
    public ScriptHandler getBuildscript() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getBuildFile() {
        return this.getBuildscript().getSourceFile();
    }

    @Override
    public void setScript(Script buildScript) {
        this.extensibleDynamicObject.addObject(new BeanDynamicObject(buildScript).withNoProperties().withNotImplementsMissing(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        return this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
    }

    @Override
    public void setGroup(Object group) {
        this.group = group;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public Object getStatus() {
        return this.status == null ? "release" : this.status;
    }

    @Override
    public void setStatus(Object status) {
        this.status = status;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.childProjects;
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        if (this.fileResolver == null) {
            this.fileResolver = (FileResolver)this.services.get(FileResolver.class);
        }
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        if (this.artifactHandler == null) {
            this.artifactHandler = (ArtifactHandler)this.services.get(ArtifactHandler.class);
        }
        return this.artifactHandler;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    @Override
    @Inject
    public RepositoryHandler getRepositories() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfigurationContainer getConfigurations() {
        if (this.configurationContainer == null) {
            this.configurationContainer = (ConfigurationContainer)this.services.get(ConfigurationContainer.class);
        }
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    @Inject
    public ProjectRegistry<ProjectInternal> getProjectRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int depthCompare(Project otherProject) {
        return new Integer(this.getDepth()).compareTo(otherProject.getDepth());
    }

    @Override
    public int compareTo(Project otherProject) {
        int depthCompare = this.depthCompare(otherProject);
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherProject.getPath());
        }
        return depthCompare;
    }

    @Override
    public String absoluteProjectPath(String path) {
        return this.path.absolutePath(path);
    }

    @Override
    public String relativeProjectPath(String path) {
        return this.path.relativePath(path);
    }

    @Override
    public ProjectInternal project(String path) {
        ProjectInternal project = this.findProject(path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public ProjectInternal findProject(String path) {
        if (!GUtil.isTrue((Object)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getProjectRegistry().getProject(this.absoluteProjectPath(path));
    }

    @Override
    public Set<Project> getAllprojects() {
        return new TreeSet<Project>(this.getProjectRegistry().getAllProjects(this.getPath()));
    }

    @Override
    public Set<Project> getSubprojects() {
        return new TreeSet<Project>(this.getProjectRegistry().getSubProjects(this.getPath()));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.configure(this.getSubprojects(), action);
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.configure(this.getAllprojects(), action);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return (AntBuilder)((Object)this.getAntBuilderFactory().create());
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public AbstractProject evaluate() {
        this.getProjectEvaluator().evaluate(this, this.state);
        this.state.rethrowFailure();
        return this;
    }

    @Override
    public ProjectInternal bindAllModelRules() {
        try {
            this.getModelRegistry().bindAllReferences();
        }
        catch (Exception e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", this), e);
        }
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    @Override
    public void addChildProject(ProjectInternal childProject) {
        this.childProjects.put(childProject.getName(), childProject);
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.file(this.buildDir);
    }

    @Override
    public void setBuildDir(Object path) {
        this.buildDir = path;
    }

    @Override
    public void evaluationDependsOnChildren() {
        for (Project project : this.childProjects.values()) {
            DefaultProject defaultProjectToEvaluate = (DefaultProject)project;
            this.evaluationDependsOn(defaultProjectToEvaluate);
        }
    }

    @Override
    public Project evaluationDependsOn(String path) {
        if (!GUtil.isTrue((Object)path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        DefaultProject projectToEvaluate = (DefaultProject)this.project(path);
        return this.evaluationDependsOn(projectToEvaluate);
    }

    private Project evaluationDependsOn(DefaultProject projectToEvaluate) {
        if (projectToEvaluate.getState().getExecuting()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        return projectToEvaluate.evaluate();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.parent == null) {
            builder.append("root ");
        }
        builder.append("project '");
        builder.append(this.parent == null ? this.name : this.path);
        builder.append("'");
        return builder.toString();
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                foundTargets.put(project, new TreeSet<Task>(project.getTasks()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTargets;
    }

    @Override
    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (!GUtil.isTrue((Object)name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                ((ProjectInternal)project).evaluate();
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTasks;
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File file(Object path) {
        return this.getFileOperations().file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.getFileOperations().file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.getFileOperations().uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.getFileOperations().files(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return ConfigureUtil.configure(closure, this.getFileOperations().files(paths));
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.getFileOperations().fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return ConfigureUtil.configure(closure, this.getFileOperations().fileTree(baseDir));
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.getFileOperations().fileTree(args);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.getFileOperations().zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.getFileOperations().tarTree(tarPath);
    }

    @Override
    public ResourceHandler getResources() {
        return this.getFileOperations().getResources();
    }

    @Override
    public String relativePath(Object path) {
        return this.getFileOperations().relativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        return this.getFileOperations().mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.getFileOperations().delete(paths);
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        if (this.antBuilderFactory == null) {
            this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        }
        return this.antBuilderFactory;
    }

    @Override
    public DependencyHandler getDependencies() {
        if (this.dependencyHandler == null) {
            this.dependencyHandler = (DependencyHandler)this.services.get(DependencyHandler.class);
        }
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return (ProjectEvaluationListener)this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("beforeEvaluate", action);
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.evaluationListener.add("afterEvaluate", action);
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.evaluationListener.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeEvaluate", closure));
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.evaluationListener.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterEvaluate", closure));
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Override
    @Inject
    public LoggingManagerInternal getLogging() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public SoftwareComponentContainer getComponents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public Map<String, ?> getProperties() {
        return (Map)DeprecationLogger.whileDisabled(new Factory<Map<String, ?>>(){

            public Map<String, ?> create() {
                return AbstractProject.this.extensibleDynamicObject.getProperties();
            }
        });
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.copy((Action<? super CopySpec>)new ClosureBackedAction(closure));
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.getFileOperations().copy(action);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.getFileOperations().sync(action);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.copySpec((Action<? super CopySpec>)new ClosureBackedAction(closure));
    }

    @Override
    public CopySpec copySpec(Action<? super CopySpec> action) {
        return (CopySpec)Actions.with((Object)this.copySpec(), action);
    }

    @Override
    public CopySpec copySpec() {
        return this.getFileOperations().copySpec();
    }

    @Inject
    protected ProcessOperations getProcessOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.javaexec((Action<? super JavaExecSpec>)new ClosureBackedAction(closure));
    }

    @Override
    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        return this.getProcessOperations().javaexec(action);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.exec((Action<? super ExecSpec>)new ClosureBackedAction(closure));
    }

    @Override
    public ExecResult exec(Action<? super ExecSpec> action) {
        return this.getProcessOperations().exec(action);
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public ServiceRegistryFactory getServiceRegistryFactory() {
        return (ServiceRegistryFactory)this.services.get(ServiceRegistryFactory.class);
    }

    @Override
    public ModuleInternal getModule() {
        return ((DependencyMetaDataProvider)this.services.get(DependencyMetaDataProvider.class)).getModule();
    }

    @Override
    public AntBuilder ant(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getAnt());
    }

    @Override
    public void subprojects(Closure configureClosure) {
        this.configure(this.getSubprojects(), configureClosure);
    }

    @Override
    public void allprojects(Closure configureClosure) {
        this.configure(this.getAllprojects(), configureClosure);
    }

    @Override
    public Project project(String path, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.project(path));
    }

    @Override
    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    @Override
    public void configurations(Closure configureClosure) {
        this.getConfigurations().configure(configureClosure);
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getArtifacts());
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public Task task(String task) {
        return this.taskContainer.create(task);
    }

    public Task task(Object task) {
        return this.taskContainer.create(task.toString());
    }

    @Override
    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.create(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.create(GUtil.addMaps((Map)options, Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.create(GUtil.addMaps((Map)options, Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    @Override
    @Inject
    public ProjectConfigurationActionContainer getConfigurationActions() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelSchemaStore getModelSchemaStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getBaseClassLoaderScope(), this);
    }

    @Override
    @Inject
    public PluginManagerInternal getPluginManager() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer()});
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<T> factory) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer(), factory});
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        Instantiator instantiator = (Instantiator)this.getServices().get(Instantiator.class);
        return (NamedDomainObjectContainer)instantiator.newInstance(FactoryNamedDomainObjectContainer.class, new Object[]{type, instantiator, new DynamicPropertyNamer(), factoryClosure});
    }

    @Override
    public ExtensionContainerInternal getExtensions() {
        return (ExtensionContainerInternal)((Object)this.getConvention());
    }

    public void model(Closure<?> modelRules) {
        ModelRegistry modelRegistry = this.getModelRegistry();
        if (TransformedModelDslBacking.isTransformedBlock(modelRules)) {
            ClosureBackedAction.execute((Object)new TransformedModelDslBacking(modelRegistry, (RelativeFilePathResolver)this.getRootProject().getFileResolver()), modelRules);
        } else {
            new NonTransformedModelDslBacking(modelRegistry).configure(modelRules);
        }
    }

    @Inject
    protected DeferredProjectConfiguration getDeferredProjectConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeferredConfiguration(Runnable configuration) {
        this.getDeferredProjectConfiguration().add(configuration);
    }

    @Override
    public void fireDeferredConfiguration() {
        this.getDeferredProjectConfiguration().fire();
    }

    static class BasicServicesRules
    extends RuleSource {
        BasicServicesRules() {
        }

        @Hidden
        @Model
        ITaskFactory taskFactory(ServiceRegistry serviceRegistry) {
            return (ITaskFactory)serviceRegistry.get(ITaskFactory.class);
        }

        @Hidden
        @Model
        ModelSchemaStore schemaStore(ServiceRegistry serviceRegistry) {
            return (ModelSchemaStore)serviceRegistry.get(ModelSchemaStore.class);
        }

        @Hidden
        @Model
        ManagedProxyFactory proxyFactory(ServiceRegistry serviceRegistry) {
            return (ManagedProxyFactory)serviceRegistry.get(ManagedProxyFactory.class);
        }

        @Hidden
        @Model
        StructBindingsStore structBindingsStore(ServiceRegistry serviceRegistry) {
            return (StructBindingsStore)serviceRegistry.get(StructBindingsStore.class);
        }

        @Hidden
        @Model
        NodeInitializerRegistry nodeInitializerRegistry(ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
            return new DefaultNodeInitializerRegistry(schemaStore, structBindingsStore);
        }

        @Hidden
        @Model
        TypeConverter typeConverter(ServiceRegistry serviceRegistry) {
            return (TypeConverter)serviceRegistry.get(TypeConverter.class);
        }

        @Hidden
        @Model
        FileOperations fileOperations(ServiceRegistry serviceRegistry) {
            return (FileOperations)serviceRegistry.get(FileOperations.class);
        }
    }
}

