/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections.jdk7;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.specs.Spec;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk7DirectoryWalker
implements DirectoryWalker {
    static boolean isAllowed(FileTreeElement element, Spec<FileTreeElement> spec) {
        return spec.isSatisfiedBy((Object)element);
    }

    @Override
    public void walkDir(File rootDir, final RelativePath rootPath, final org.gradle.api.file.FileVisitor visitor, final Spec<FileTreeElement> spec, final AtomicBoolean stopFlag, final FileSystem fileSystem, final boolean postfix) {
        final LinkedList directoryDetailsHolder = new LinkedList();
        try {
            Files.walkFileTree(rootDir.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    FileVisitDetails details = this.getFileVisitDetails(dir, attrs, true);
                    if (directoryDetailsHolder.size() == 0 || Jdk7DirectoryWalker.isAllowed(details, (Spec<FileTreeElement>)spec)) {
                        directoryDetailsHolder.push(details);
                        if (directoryDetailsHolder.size() > 1 && !postfix) {
                            visitor.visitDir(details);
                        }
                        return this.checkStopFlag();
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                private FileVisitResult checkStopFlag() {
                    return stopFlag.get() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isSymbolicLink()) {
                        throw new GradleException(String.format("Could not list contents of '%s'. Couldn't follow symbolic link.", file));
                    }
                    FileVisitDetails details = this.getFileVisitDetails(file, attrs, false);
                    if (Jdk7DirectoryWalker.isAllowed(details, (Spec<FileTreeElement>)spec)) {
                        visitor.visitFile(details);
                    }
                    return this.checkStopFlag();
                }

                private FileVisitDetails getFileVisitDetails(Path file, BasicFileAttributes attrs, boolean isDirectory) {
                    File child = file.toFile();
                    FileVisitDetails dirDetails = (FileVisitDetails)directoryDetailsHolder.peek();
                    RelativePath childPath = dirDetails != null ? dirDetails.getRelativePath().append(!isDirectory, child.getName()) : rootPath;
                    return new DefaultFileVisitDetails(child, childPath, stopFlag, (Chmod)fileSystem, (Stat)fileSystem, isDirectory, attrs.lastModifiedTime().toMillis(), attrs.size());
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (exc != null && !(exc instanceof FileSystemLoopException)) {
                        throw new GradleException(String.format("Could not read path '%s'.", file), (Throwable)exc);
                    }
                    return this.checkStopFlag();
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        if (!(exc instanceof FileSystemLoopException)) {
                            throw new GradleException(String.format("Could not read directory path '%s'.", dir), (Throwable)exc);
                        }
                    } else if (postfix) {
                        FileVisitDetails details = (FileVisitDetails)directoryDetailsHolder.peek();
                        if (directoryDetailsHolder.size() > 1 && details != null) {
                            visitor.visitDir(details);
                        }
                    }
                    directoryDetailsHolder.pop();
                    return this.checkStopFlag();
                }
            });
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not list contents of directory '%s'.", rootDir), (Throwable)e);
        }
    }
}

