/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class CachingFileVisitDetails
extends DefaultFileVisitDetails {
    private static final FileSystem DEFAULT_FILESYSTEM = FileSystems.getDefault();
    private final boolean isDirectory;
    private volatile long size = -1L;
    private volatile long lastModified = -1L;

    public CachingFileVisitDetails(File file, RelativePath relativePath, AtomicBoolean stop, Chmod chmod, Stat stat, boolean isDirectory) {
        super(file, relativePath, stop, chmod, stat);
        this.isDirectory = isDirectory;
    }

    public CachingFileVisitDetails(File file) {
        this(file, new RelativePath(true, file.getName()), new AtomicBoolean(), (Chmod)DEFAULT_FILESYSTEM, (Stat)DEFAULT_FILESYSTEM, false);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getSize() {
        if (this.size == -1L) {
            this.size = super.getSize();
        }
        return this.size;
    }

    public long getLastModified() {
        if (this.lastModified == -1L) {
            this.lastModified = super.getLastModified();
        }
        return this.lastModified;
    }
}

