/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputFileChange;
import org.gradle.api.internal.changedetection.rules.DiscoveredTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.util.ChangeListener;

public class DiscoveredInputFilesStateChangeRule {
    public static DiscoveredTaskStateChanges create(final TaskExecution previousExecution, final TaskExecution currentExecution, final FileCollectionSnapshotter inputFilesSnapshotter) {
        return new DiscoveredTaskStateChanges(){
            private final Collection<File> discoveredFiles = Sets.newHashSet();

            @Override
            public Iterator<TaskStateChange> iterator() {
                if (previousExecution.getDiscoveredInputFilesSnapshot() == null) {
                    return Collections.singleton(new DescriptiveChange("Discovered input file history is not available.", new Object[0])).iterator();
                }
                Iterables.addAll(this.discoveredFiles, (Iterable)previousExecution.getDiscoveredInputFilesSnapshot().getFiles());
                final FileCollectionSnapshot discoveredFileSnapshot = inputFilesSnapshotter.snapshot(new SimpleFileCollection(this.discoveredFiles));
                return new AbstractIterator<TaskStateChange>(){
                    final FileCollectionSnapshot.ChangeIterator<String> changeIterator;
                    final ChangeListenerAdapter listenerAdapter;
                    {
                        this.changeIterator = discoveredFileSnapshot.iterateChangesSince(previousExecution.getDiscoveredInputFilesSnapshot());
                        this.listenerAdapter = new ChangeListenerAdapter();
                    }

                    protected TaskStateChange computeNext() {
                        if (this.changeIterator.next(this.listenerAdapter)) {
                            return this.listenerAdapter.lastChange;
                        }
                        return (TaskStateChange)this.endOfData();
                    }
                };
            }

            @Override
            public void newInputs(Set<File> files) {
                this.discoveredFiles.clear();
                this.discoveredFiles.addAll(files);
            }

            @Override
            public void snapshotAfterTask() {
                currentExecution.setDiscoveredInputFilesSnapshot(inputFilesSnapshotter.snapshot(new SimpleFileCollection(this.discoveredFiles)));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeListenerAdapter
    implements ChangeListener<String> {
        public InputFileChange lastChange;

        private ChangeListenerAdapter() {
        }

        @Override
        public void added(String fileName) {
            this.lastChange = new DiscoveredInputFileChange(fileName, ChangeType.ADDED);
        }

        @Override
        public void removed(String fileName) {
            this.lastChange = new DiscoveredInputFileChange(fileName, ChangeType.REMOVED);
        }

        @Override
        public void changed(String fileName) {
            this.lastChange = new DiscoveredInputFileChange(fileName, ChangeType.MODIFIED);
        }
    }
}

