/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.internal.DefaultPluginRequest;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDependenciesService {
    private final ScriptSource scriptSource;
    private final List<DependencySpecImpl> specs = new LinkedList<DependencySpecImpl>();

    public PluginDependenciesService(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public PluginDependenciesSpec createSpec(final int lineNumber) {
        return new PluginDependenciesSpec(){

            public PluginDependencySpec id(String id) {
                DependencySpecImpl spec = new DependencySpecImpl(id, lineNumber);
                PluginDependenciesService.this.specs.add(spec);
                return spec;
            }
        };
    }

    public List<PluginRequest> getRequests() {
        return CollectionUtils.collect(this.specs, (Transformer)new Transformer<PluginRequest, DependencySpecImpl>(){

            public PluginRequest transform(DependencySpecImpl original) {
                return new DefaultPluginRequest(original.id, original.version, original.lineNumber, PluginDependenciesService.this.scriptSource);
            }
        });
    }

    private static class DependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;
        private String version;
        private final int lineNumber;

        private DependencySpecImpl(String id, int lineNumber) {
            this.id = PluginId.of(id);
            this.lineNumber = lineNumber;
        }

        public void version(String version) {
            this.version = version;
        }
    }
}

