/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collections;
import org.gradle.StartParameter;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    private final GradleLauncherFactory gradleLauncherFactory;
    private final BuildCancellationToken cancellationToken;
    private final ClassLoaderScope classLoaderScope;
    private final CacheRepository cacheRepository;

    public BuildSourceBuilder(GradleLauncherFactory gradleLauncherFactory, BuildCancellationToken cancellationToken, ClassLoaderScope classLoaderScope, CacheRepository cacheRepository) {
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.cancellationToken = cancellationToken;
        this.classLoaderScope = classLoaderScope;
        this.cacheRepository = cacheRepository;
    }

    public ClassLoaderScope buildAndCreateClassLoader(StartParameter startParameter) {
        ClassPath classpath = this.createBuildSourceClasspath(startParameter);
        if (classpath.isEmpty()) {
            return this.classLoaderScope;
        }
        ClassLoaderScope childScope = this.classLoaderScope.createChild();
        childScope.export(this.classLoaderScope.loader(classpath));
        childScope.lock();
        return childScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassPath createBuildSourceClasspath(StartParameter startParameter) {
        assert (startParameter.getCurrentDir() != null && startParameter.getBuildFile() == null);
        LOGGER.debug("Starting to build the build sources.");
        if (!startParameter.getCurrentDir().isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return new DefaultClassPath(new File[0]);
        }
        LOGGER.info("================================================ Start building buildSrc");
        PersistentCache buildSrcCache = this.createCache(startParameter);
        try {
            ClassPath classPath;
            GradleLauncher gradleLauncher = this.buildGradleLauncher(startParameter);
            try {
                classPath = (ClassPath)buildSrcCache.useCache("rebuild buildSrc", new BuildSrcUpdateFactory(buildSrcCache, gradleLauncher, new BuildSrcBuildListenerFactory()));
            }
            catch (Throwable throwable) {
                gradleLauncher.stop();
                throw throwable;
            }
            gradleLauncher.stop();
            return classPath;
        }
        finally {
            buildSrcCache.close();
        }
    }

    PersistentCache createCache(StartParameter startParameter) {
        return this.cacheRepository.cache(new File(startParameter.getCurrentDir(), ".gradle/noVersion/buildSrc")).withCrossVersionCache().withDisplayName("buildSrc state cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None).useCrossVersionImplementation()).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
    }

    private GradleLauncher buildGradleLauncher(StartParameter startParameter) {
        StartParameter startParameterArg = startParameter.newInstance();
        startParameterArg.setProjectProperties(startParameter.getProjectProperties());
        startParameterArg.setSearchUpwards(false);
        startParameterArg.setProfile(startParameter.isProfile());
        return this.gradleLauncherFactory.newInstance(startParameterArg, this.cancellationToken);
    }
}

