/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import org.gradle.api.Nullable;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.messaging.serialize.BaseSerializerFactory;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentIndexedCacheParameters<K, V> {
    private static final BaseSerializerFactory SERIALIZER_FACTORY = new BaseSerializerFactory();
    private final String cacheName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private CacheDecorator cacheDecorator;

    public PersistentIndexedCacheParameters(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cacheName = cacheName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public static <K, V> PersistentIndexedCacheParameters<K, V> of(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new PersistentIndexedCacheParameters<K, V>(cacheName, keySerializer, valueSerializer);
    }

    public PersistentIndexedCacheParameters(String cacheName, Class<K> keyType, Serializer<V> valueSerializer) {
        this(cacheName, SERIALIZER_FACTORY.getSerializerFor(keyType), valueSerializer);
    }

    public PersistentIndexedCacheParameters(String cacheName, Class<K> keyType, Class<V> valueType) {
        this(cacheName, keyType, SERIALIZER_FACTORY.getSerializerFor(valueType));
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Nullable
    public CacheDecorator getCacheDecorator() {
        return this.cacheDecorator;
    }

    public PersistentIndexedCacheParameters<K, V> cacheDecorator(CacheDecorator cacheDecorator) {
        assert (cacheDecorator != null);
        this.cacheDecorator = cacheDecorator;
        return this;
    }
}

