/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedFileSnapshotRepository
implements FileSnapshotRepository {
    private final PersistentIndexedCache<Long, FileCollectionSnapshot> cache;
    private IdGenerator<Long> idGenerator = new RandomLongIdGenerator();

    public CacheBackedFileSnapshotRepository(TaskArtifactStateCacheAccess cacheAccess, Serializer<FileCollectionSnapshot> serializer, IdGenerator<Long> idGenerator) {
        this.idGenerator = idGenerator;
        this.cache = cacheAccess.createCache("fileSnapshots", Long.class, serializer);
    }

    @Override
    public Long add(FileCollectionSnapshot snapshot) {
        Long id = (Long)this.idGenerator.generateId();
        this.cache.put(id, snapshot);
        return id;
    }

    @Override
    public FileCollectionSnapshot get(Long id) {
        return this.cache.get(id);
    }

    @Override
    public void remove(Long id) {
        this.cache.remove(id);
    }
}

