/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

public class DynamicModulesClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;

    public DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    public ClassPath findClassPath(String name) {
        if (name.equals("GRADLE_PLUGINS")) {
            DefaultClassPath classpath = new DefaultClassPath(new File[0]);
            for (Module pluginModule : this.pluginModuleRegistry.getPluginModules()) {
                classpath = classpath.plus(pluginModule.getClasspath());
            }
            return classpath;
        }
        if (name.equals("GRADLE_CORE_IMPL")) {
            Set<Module> coreModules = this.moduleRegistry.getModule("gradle-core").getAllRequiredModules();
            DefaultClassPath classpath = new DefaultClassPath(new File[0]);
            for (String moduleName : Arrays.asList("gradle-core-impl", "gradle-plugin-use")) {
                for (Module module : this.moduleRegistry.getModule(moduleName).getAllRequiredModules()) {
                    if (coreModules.contains(module)) continue;
                    classpath = classpath.plus(module.getClasspath());
                }
            }
            return classpath;
        }
        return null;
    }
}

