/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.messaging.remote.Address;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.ImplementationClassLoaderWorker;
import org.gradle.process.internal.child.IsolatedApplicationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.GradleWorkerMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInIsolatedClassLoaderWorkerFactory
implements WorkerFactory {
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final Collection<URL> implementationClassPath;
    private final Address serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInIsolatedClassLoaderWorkerFactory(Object workerId, String displayName, WorkerProcessBuilder processBuilder, Collection<URL> implementationClassPath, Address serverAddress, ClassPathRegistry classPathRegistry) {
        this.workerId = workerId;
        this.displayName = displayName;
        this.processBuilder = processBuilder;
        this.implementationClassPath = implementationClassPath;
        this.serverAddress = serverAddress;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public void prepareJavaCommand(JavaExecSpec execSpec) {
        execSpec.setMain(GradleWorkerMain.class.getName());
        execSpec.classpath(this.classPathRegistry.getClassPath("WORKER_PROCESS").getAsFiles());
    }

    @Override
    public Callable<?> create() {
        List applicationClassPath = new DefaultClassPath(this.processBuilder.getApplicationClasspath()).getAsURIs();
        ActionExecutionWorker injectedWorker = new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress);
        ImplementationClassLoaderWorker worker = new ImplementationClassLoaderWorker(this.processBuilder.getLogLevel(), this.processBuilder.getSharedPackages(), this.implementationClassPath, injectedWorker);
        return new IsolatedApplicationClassLoaderWorker(applicationClassPath, worker);
    }
}

