/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.OutputStream;
import java.io.PrintStream;
import org.gradle.api.Action;
import org.gradle.internal.nativeplatform.console.ConsoleDetector;
import org.gradle.internal.nativeplatform.console.ConsoleMetaData;
import org.gradle.internal.nativeplatform.services.NativeServices;
import org.gradle.logging.internal.AnsiConsole;
import org.gradle.logging.internal.OutputEventRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleConfigureAction
implements Action<OutputEventRenderer> {
    public void execute(OutputEventRenderer renderer) {
        ConsoleDetector consoleDetector = (ConsoleDetector)NativeServices.getInstance().get(ConsoleDetector.class);
        ConsoleMetaData consoleMetaData = consoleDetector.getConsole();
        if (consoleMetaData == null) {
            return;
        }
        boolean stdOutIsTerminal = consoleMetaData.isStdOut();
        boolean stdErrIsTerminal = consoleMetaData.isStdErr();
        if (stdOutIsTerminal) {
            PrintStream outStr = new PrintStream(org.fusesource.jansi.AnsiConsole.wrapOutputStream((OutputStream)renderer.getOriginalStdOut()));
            AnsiConsole console = new AnsiConsole(outStr, outStr, renderer.getColourMap());
            renderer.addConsole(console, true, stdErrIsTerminal, consoleMetaData);
        } else if (stdErrIsTerminal) {
            PrintStream errStr = new PrintStream(org.fusesource.jansi.AnsiConsole.wrapOutputStream((OutputStream)renderer.getOriginalStdErr()));
            AnsiConsole console = new AnsiConsole(errStr, errStr, renderer.getColourMap());
            renderer.addConsole(console, false, true, consoleMetaData);
        }
    }
}

