/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.taskgraph.TaskDependencyGraph;
import org.gradle.execution.taskgraph.TaskDependencyGraphEdge;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<TaskInfo> tasksInUnknownState = new LinkedHashSet<TaskInfo>();
    private final Set<TaskInfo> entryTasks = new LinkedHashSet<TaskInfo>();
    private final TaskDependencyGraph graph = new TaskDependencyGraph();
    private final LinkedHashMap<Task, TaskInfo> executionPlan = new LinkedHashMap();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new RethrowingFailureHandler();
    private final List<String> runningProjects = new ArrayList<String>();

    DefaultTaskExecutionPlan() {
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        TaskInfo node;
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>();
        ArrayList<? extends Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        for (Task task : sortedTasks) {
            node = this.graph.addNode(task);
            if (node.getMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy((Object)task)) {
                node.require();
            }
            this.entryTasks.add(node);
            queue.add(node);
        }
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        CachingTaskDependencyResolveContext cachingTaskDependencyResolveContext = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            boolean filtered;
            node = (TaskInfo)queue.get(0);
            if (node.getDependenciesProcessed()) {
                queue.remove(0);
                continue;
            }
            TaskInternal task = node.getTask();
            boolean bl = filtered = !this.filter.isSatisfiedBy((Object)task);
            if (filtered) {
                queue.remove(0);
                node.dependenciesProcessed();
                node.doNotRequire();
                continue;
            }
            if (visiting.add(node)) {
                TaskInfo targetNode;
                Set<? extends Task> dependsOnTasks = cachingTaskDependencyResolveContext.getDependencies(task);
                for (Task task2 : dependsOnTasks) {
                    targetNode = this.graph.addNode(task2);
                    node.addDependencySuccessor(targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task3 : task.getFinalizedBy().getDependencies(task)) {
                    targetNode = this.graph.addNode(task3);
                    this.addFinalizerNode(node, targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task4 : task.getMustRunAfter().getDependencies(task)) {
                    targetNode = this.graph.addNode(task4);
                    node.addMustSuccessor(targetNode);
                }
                for (Task task5 : task.getShouldRunAfter().getDependencies(task)) {
                    targetNode = this.graph.addNode(task5);
                    node.addShouldSuccessor(targetNode);
                }
                if (node.isRequired()) {
                    for (TaskInfo taskInfo : node.getDependencySuccessors()) {
                        if (!this.filter.isSatisfiedBy((Object)taskInfo.getTask())) continue;
                        taskInfo.require();
                    }
                    continue;
                }
                this.tasksInUnknownState.add(node);
                continue;
            }
            queue.remove(0);
            visiting.remove(node);
            node.dependenciesProcessed();
        }
        this.resolveTasksInUnknownState();
    }

    private void resolveTasksInUnknownState() {
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>(this.tasksInUnknownState);
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        block0: while (!queue.isEmpty()) {
            TaskInfo task = (TaskInfo)queue.get(0);
            if (task.isInKnownState()) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                for (TaskInfo hardPredecessor : task.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.add(0, hardPredecessor);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            task.mustNotRun();
            for (TaskInfo predecessor : task.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.getMustNotRun());
                if (!predecessor.isRequired()) continue;
                task.require();
                continue block0;
            }
        }
    }

    private void addFinalizerNode(TaskInfo node, TaskInfo finalizerNode) {
        if (this.filter.isSatisfiedBy((Object)finalizerNode.getTask())) {
            node.addFinalizer(finalizerNode);
            if (!finalizerNode.isInKnownState()) {
                finalizerNode.mustNotRun();
            }
            finalizerNode.addMustSuccessor(node);
        }
    }

    private <T> void addAllReversed(List<T> list, TreeSet<T> set) {
        List elements = CollectionUtils.toList(set);
        Collections.reverse(elements);
        list.addAll(elements);
    }

    private void requireWithDependencies(TaskInfo taskInfo) {
        if (taskInfo.getMustNotRun() && this.filter.isSatisfiedBy((Object)taskInfo.getTask())) {
            taskInfo.require();
            for (TaskInfo dependency : taskInfo.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        ArrayList<TaskInfo> nodeQueue = new ArrayList<TaskInfo>(this.entryTasks);
        HashSet<TaskInfo> visitingNodes = new HashSet<TaskInfo>();
        Stack<TaskDependencyGraphEdge> walkedShouldRunAfterEdges = new Stack<TaskDependencyGraphEdge>();
        Stack<TaskInfo> path = new Stack<TaskInfo>();
        HashMap<TaskInfo, Integer> planBeforeVisiting = new HashMap<TaskInfo, Integer>();
        while (!nodeQueue.isEmpty()) {
            TaskInfo taskNode = (TaskInfo)nodeQueue.get(0);
            if (taskNode.isIncludeInGraph() || this.executionPlan.containsKey(taskNode.getTask())) {
                nodeQueue.remove(0);
                continue;
            }
            if (visitingNodes.add(taskNode)) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, taskNode);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle(visitingNodes, taskNode);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, taskNode);
                ArrayList<TaskInfo> successors = new ArrayList<TaskInfo>();
                this.addAllSuccessorsInReverseOrder(taskNode, successors);
                for (TaskInfo successor : successors) {
                    if (visitingNodes.contains(successor)) {
                        if (!walkedShouldRunAfterEdges.empty()) {
                            TaskDependencyGraphEdge toBeRemoved = walkedShouldRunAfterEdges.pop();
                            toBeRemoved.getFrom().removeShouldRunAfterSuccessor(toBeRemoved.getTo());
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle();
                    }
                    nodeQueue.add(0, successor);
                }
                path.push(taskNode);
                continue;
            }
            nodeQueue.remove(0);
            visitingNodes.remove(taskNode);
            path.pop();
            this.executionPlan.put(taskNode.getTask(), taskNode);
            ArrayList finalizerTasks = new ArrayList();
            this.addAllReversed(finalizerTasks, taskNode.getFinalizers());
            for (TaskInfo finalizer : finalizerTasks) {
                if (visitingNodes.contains(finalizer) || nodeQueue.contains(finalizer)) continue;
                nodeQueue.add(this.finalizerTaskPosition(finalizer, nodeQueue), finalizer);
            }
        }
    }

    private void restoreExecutionPlan(HashMap<TaskInfo, Integer> planBeforeVisiting, TaskDependencyGraphEdge toBeRemoved) {
        Iterator<Map.Entry<Task, TaskInfo>> executionPlanIterator = this.executionPlan.entrySet().iterator();
        for (int i = 0; i < planBeforeVisiting.get(toBeRemoved.getFrom()); ++i) {
            executionPlanIterator.next();
        }
        while (executionPlanIterator.hasNext()) {
            executionPlanIterator.next();
            executionPlanIterator.remove();
        }
    }

    private void restoreQueue(List<TaskInfo> nodeQueue, Set<TaskInfo> visitingNodes, TaskDependencyGraphEdge toBeRemoved) {
        TaskInfo nextInQueue = null;
        while (!toBeRemoved.getFrom().equals(nextInQueue)) {
            nextInQueue = nodeQueue.get(0);
            visitingNodes.remove(nextInQueue);
            if (toBeRemoved.getFrom().equals(nextInQueue)) continue;
            nodeQueue.remove(0);
        }
    }

    private void restorePath(Stack<TaskInfo> path, TaskDependencyGraphEdge toBeRemoved) {
        TaskInfo removedFromPath = null;
        while (!toBeRemoved.getFrom().equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void addAllSuccessorsInReverseOrder(TaskInfo taskNode, ArrayList<TaskInfo> dependsOnTasks) {
        this.addAllReversed(dependsOnTasks, taskNode.getDependencySuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getMustSuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getShouldSuccessors());
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(Set<TaskInfo> visitingNodes, TaskInfo taskNode) {
        for (TaskInfo shouldRunAfterSuccessor : taskNode.getShouldSuccessors()) {
            if (!visitingNodes.contains(shouldRunAfterSuccessor)) continue;
            taskNode.removeShouldRunAfterSuccessor(shouldRunAfterSuccessor);
        }
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(HashMap<TaskInfo, Integer> planBeforeVisiting, TaskInfo taskNode) {
        if (taskNode.getShouldSuccessors().size() > 0) {
            planBeforeVisiting.put(taskNode, this.executionPlan.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Stack<TaskDependencyGraphEdge> walkedShouldRunAfterEdges, Stack<TaskInfo> path, TaskInfo taskNode) {
        if (!path.empty() && path.peek().getShouldSuccessors().contains(taskNode)) {
            walkedShouldRunAfterEdges.push(new TaskDependencyGraphEdge(path.peek(), taskNode));
        }
    }

    private int finalizerTaskPosition(TaskInfo finalizer, final List<TaskInfo> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        ArrayList<TaskInfo> dependsOnTasks = new ArrayList<TaskInfo>();
        dependsOnTasks.addAll(finalizer.getDependencySuccessors());
        dependsOnTasks.addAll(finalizer.getMustSuccessors());
        dependsOnTasks.addAll(finalizer.getShouldSuccessors());
        List dependsOnTaskIndexes = CollectionUtils.collect(dependsOnTasks, (Transformer)new Transformer<Integer, TaskInfo>(){

            public Integer transform(TaskInfo dependsOnTask) {
                return nodeQueue.indexOf(dependsOnTask);
            }
        });
        return (Integer)Collections.max(dependsOnTaskIndexes) + 1;
    }

    private void onOrderingCycle() {
        CachingDirectedGraphWalker<TaskInfo, Void> graphWalker = new CachingDirectedGraphWalker<TaskInfo, Void>(new DirectedGraph<TaskInfo, Void>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Void> values, Collection<? super TaskInfo> connectedNodes) {
                connectedNodes.addAll(node.getDependencySuccessors());
                connectedNodes.addAll(node.getMustSuccessors());
            }
        });
        graphWalker.add((Iterable<TaskInfo>)this.entryTasks);
        final ArrayList firstCycle = new ArrayList(graphWalker.findCycles().get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<TaskInfo> graphRenderer = new DirectedGraphRenderer<TaskInfo>(new GraphNodeRenderer<TaskInfo>(){

            @Override
            public void renderTo(TaskInfo node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text(node.getTask().getPath());
            }
        }, new DirectedGraph<TaskInfo, Object>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Object> values, Collection<? super TaskInfo> connectedNodes) {
                for (TaskInfo dependency : firstCycle) {
                    if (!node.getDependencySuccessors().contains(dependency) && !node.getMustSuccessors().contains(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((TaskInfo)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.graph.clear();
            this.entryTasks.clear();
            this.executionPlan.clear();
            this.failures.clear();
            this.runningProjects.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Task> getTasks() {
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void useFailureHandler(TaskFailureHandler handler) {
        this.failureHandler = handler;
    }

    @Override
    public TaskInfo getTaskToExecute() {
        this.lock.lock();
        try {
            while (true) {
                TaskInfo nextMatching = null;
                boolean allTasksComplete = true;
                for (TaskInfo taskInfo : this.executionPlan.values()) {
                    boolean bl = allTasksComplete = allTasksComplete && taskInfo.isComplete();
                    if (!taskInfo.isReady() || !taskInfo.allDependenciesComplete() || this.runningProjects.contains(taskInfo.getTask().getProject().getPath())) continue;
                    nextMatching = taskInfo;
                    break;
                }
                if (allTasksComplete) {
                    Iterator<TaskInfo> i$ = null;
                    return i$;
                }
                if (nextMatching == null) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (nextMatching.allDependenciesSuccessful()) {
                    nextMatching.startExecution();
                    this.runningProjects.add(nextMatching.getTask().getProject().getPath());
                    TaskInfo taskInfo = nextMatching;
                    return taskInfo;
                }
                nextMatching.skipExecution();
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskComplete(TaskInfo taskInfo) {
        this.lock.lock();
        try {
            this.enforceFinalizerTasks(taskInfo);
            if (taskInfo.isFailed()) {
                this.handleFailure(taskInfo);
            }
            taskInfo.finishExecution();
            this.runningProjects.remove(taskInfo.getTask().getProject().getPath());
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void enforceFinalizerTasks(TaskInfo taskInfo) {
        for (TaskInfo finalizerNode : taskInfo.getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.getMustNotRun()) continue;
            this.enforceWithDependencies(finalizerNode);
        }
    }

    private void enforceWithDependencies(TaskInfo node) {
        for (TaskInfo dependencyNode : node.getDependencySuccessors()) {
            this.enforceWithDependencies(dependencyNode);
        }
        if (node.getMustNotRun() || node.isRequired()) {
            node.enforceRun();
        }
    }

    private void handleFailure(TaskInfo taskInfo) {
        Throwable executionFailure = taskInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failures.add(executionFailure);
            return;
        }
        try {
            this.failureHandler.onTaskFailure(taskInfo.getTask());
            this.failures.add(taskInfo.getTaskFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failures.add(e);
        }
    }

    private void abortExecution() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (!taskInfo.isRequired()) continue;
            taskInfo.skipExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitCompletion() {
        this.lock.lock();
        try {
            while (!this.allTasksComplete()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rethrowFailures();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rethrowFailures() {
        if (this.failures.isEmpty()) {
            return;
        }
        if (this.failures.size() > 1) {
            throw new MultipleBuildFailures(this.failures);
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)this.failures.get(0));
    }

    private boolean allTasksComplete() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    private static class RethrowingFailureHandler
    implements TaskFailureHandler {
        private RethrowingFailureHandler() {
        }

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    }
}

