/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.MaybeCompressedFileResource;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceHandler;

public class DefaultResourceHandler
implements ResourceHandler {
    private final FileResolver resolver;

    public DefaultResourceHandler(FileResolver resolver) {
        this.resolver = resolver;
    }

    public ReadableResource gzip(Object path) {
        return new GzipArchiver(this.resolver.resolveResource(path));
    }

    public ReadableResource bzip2(Object path) {
        return new Bzip2Archiver(this.resolver.resolveResource(path));
    }

    public ReadableResource maybeCompressed(Object tarPath) {
        if (tarPath instanceof ReadableResource) {
            return (ReadableResource)tarPath;
        }
        return new MaybeCompressedFileResource(this.resolver.resolveResource(tarPath));
    }
}

