/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Nullable;
import org.gradle.api.internal.initialization.ClassLoaderCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderCache
implements ClassLoaderCache {
    private final Cache<Key, ClassLoader> cache;

    public DefaultClassLoaderCache() {
        this((Cache<Key, ClassLoader>)CacheBuilder.newBuilder().build());
    }

    public DefaultClassLoaderCache(Cache<Key, ClassLoader> cache) {
        this.cache = cache;
    }

    @Override
    public ClassLoader get(final ClassLoader parent, final ClassPath classPath, final @Nullable FilteringClassLoader.Spec filterSpec) {
        try {
            return (ClassLoader)this.cache.get((Object)new Key(parent, classPath, filterSpec), (Callable)new Callable<ClassLoader>(){

                @Override
                public ClassLoader call() throws Exception {
                    if (filterSpec == null) {
                        return new URLClassLoader(classPath.getAsURLArray(), parent);
                    }
                    return new FilteringClassLoader(DefaultClassLoaderCache.this.get(parent, classPath, null), filterSpec);
                }
            });
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static class Key {
        private final ClassLoader parent;
        private final ClassPath classPath;
        private final FilteringClassLoader.Spec filterSpec;

        private Key(ClassLoader parent, ClassPath classPath, FilteringClassLoader.Spec filterSpec) {
            this.parent = parent;
            this.classPath = classPath;
            this.filterSpec = filterSpec;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.classPath.equals(key.classPath)) {
                return false;
            }
            if (this.filterSpec != null ? !this.filterSpec.equals((Object)key.filterSpec) : key.filterSpec != null) {
                return false;
            }
            return this.parent.equals(key.parent);
        }

        public int hashCode() {
            int result = this.parent.hashCode();
            result = 31 * result + this.classPath.hashCode();
            result = 31 * result + (this.filterSpec != null ? this.filterSpec.hashCode() : 0);
            return result;
        }
    }
}

