/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteAction;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.archive.TarFileTree;
import org.gradle.api.internal.file.archive.ZipFileTree;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.DeleteActionImpl;
import org.gradle.api.internal.file.copy.FileCopier;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.nativeplatform.filesystem.Chmod;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileOperations
implements FileOperations,
ProcessOperations,
ExecActionFactory {
    private final FileResolver fileResolver;
    private final TaskResolver taskResolver;
    private final TemporaryFileProvider temporaryFileProvider;
    private final Instantiator instantiator;
    private final DeleteAction deleteAction;
    private final DefaultResourceHandler resourceHandler;
    private final FileCopier fileCopier;
    private final FileSystem fileSystem;

    public DefaultFileOperations(FileResolver fileResolver, TaskResolver taskResolver, TemporaryFileProvider temporaryFileProvider, Instantiator instantiator, FileLookup fileLookup) {
        this.fileResolver = fileResolver;
        this.taskResolver = taskResolver;
        this.temporaryFileProvider = temporaryFileProvider;
        this.instantiator = instantiator;
        this.deleteAction = new DeleteActionImpl(fileResolver);
        this.resourceHandler = new DefaultResourceHandler(fileResolver);
        this.fileCopier = new FileCopier(this.instantiator, this.fileResolver, fileLookup);
        this.fileSystem = fileLookup.getFileSystem();
    }

    @Override
    public File file(Object path) {
        return this.fileResolver.resolve(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileResolver.resolve(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileResolver.resolveUri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return new DefaultConfigurableFileCollection(this.fileResolver, this.taskResolver, paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.files(paths));
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return new DefaultConfigurableFileTree(baseDir, this.fileResolver, this.taskResolver, this.fileCopier);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return ConfigureUtil.configure(closure, this.fileTree(baseDir));
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return new DefaultConfigurableFileTree(args, this.fileResolver, this.taskResolver, this.fileCopier);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return new FileTreeAdapter(new ZipFileTree(this.file(zipPath), this.getExpandDir(), (Chmod)this.fileSystem));
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        ReadableResource res = this.getResources().maybeCompressed(tarPath);
        TarFileTree tarTree = new TarFileTree(res, this.getExpandDir(), (Chmod)this.fileSystem);
        return new FileTreeAdapter(tarTree);
    }

    private File getExpandDir() {
        return this.temporaryFileProvider.newTemporaryFile("expandedArchives");
    }

    @Override
    public String relativePath(Object path) {
        return this.fileResolver.resolveAsRelativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        File dir = this.fileResolver.resolve(path);
        if (dir.isFile()) {
            throw new InvalidUserDataException(String.format("Can't create directory. The path=%s points to an existing file.", path));
        }
        GFileUtils.mkdirs(dir);
        return dir;
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.deleteAction.delete(paths);
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.fileCopier.copy(new ClosureBackedAction(closure));
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileCopier.sync(action);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return this.copySpec(new ClosureBackedAction(closure));
    }

    @Override
    public CopySpec copySpec(Action<? super CopySpec> action) {
        DefaultCopySpec copySpec = (DefaultCopySpec)this.instantiator.newInstance(DefaultCopySpec.class, new Object[]{this.fileResolver, this.instantiator});
        action.execute((Object)copySpec);
        return copySpec;
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public ExecResult javaexec(Closure cl) {
        JavaExecAction javaExecAction = (JavaExecAction)ConfigureUtil.configure(cl, this.instantiator.newInstance(DefaultJavaExecAction.class, new Object[]{this.fileResolver}));
        return javaExecAction.execute();
    }

    @Override
    public ExecResult exec(Closure cl) {
        ExecAction execAction = (ExecAction)ConfigureUtil.configure(cl, this.instantiator.newInstance(DefaultExecAction.class, new Object[]{this.fileResolver}));
        return execAction.execute();
    }

    @Override
    public ExecAction newExecAction() {
        return new DefaultExecAction(this.fileResolver);
    }

    @Override
    public DefaultResourceHandler getResources() {
        return this.resourceHandler;
    }
}

