/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileTree
extends CompositeFileCollection
implements FileTree {
    protected List<FileTree> getSourceCollections() {
        return super.getSourceCollections();
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, fileTree);
    }

    @Override
    public FileTree matching(Closure filterConfigClosure) {
        return new FilteredFileTree(filterConfigClosure);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        return new FilteredFileTree(patterns);
    }

    @Override
    public FileTree visit(Closure visitor) {
        for (FileTree tree : this.getSourceCollections()) {
            tree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        for (FileTree tree : this.getSourceCollections()) {
            tree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    private class FilteredFileTree
    extends CompositeFileTree {
        private final Closure closure;
        private final PatternFilterable patterns;

        public FilteredFileTree(Closure closure) {
            this.closure = closure;
            this.patterns = null;
        }

        public FilteredFileTree(PatternFilterable patterns) {
            this.patterns = patterns;
            this.closure = null;
        }

        public String getDisplayName() {
            return CompositeFileTree.this.getDisplayName();
        }

        public TaskDependency getBuildDependencies() {
            return CompositeFileTree.this.getBuildDependencies();
        }

        public void resolve(FileCollectionResolveContext context) {
            ResolvableFileCollectionResolveContext nestedContext = context.newContext();
            CompositeFileTree.this.resolve(nestedContext);
            for (FileTree set : nestedContext.resolveAsFileTrees()) {
                if (this.closure != null) {
                    context.add(set.matching(this.closure));
                    continue;
                }
                context.add(set.matching(this.patterns));
            }
        }
    }
}

