/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshotter;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileSnapshotterSerializer
implements Serializer<DefaultFileCollectionSnapshotter.FileCollectionSnapshotImpl> {
    DefaultFileSnapshotterSerializer() {
    }

    public DefaultFileCollectionSnapshotter.FileCollectionSnapshotImpl read(Decoder decoder) throws Exception {
        HashMap<String, DefaultFileCollectionSnapshotter.FileSnapshot> snapshots = new HashMap<String, DefaultFileCollectionSnapshotter.FileSnapshot>();
        DefaultFileCollectionSnapshotter.FileCollectionSnapshotImpl snapshot = new DefaultFileCollectionSnapshotter.FileCollectionSnapshotImpl(snapshots);
        int snapshotsCount = decoder.readSmallInt();
        for (int i = 0; i < snapshotsCount; ++i) {
            String key = decoder.readString();
            byte fileSnapshotKind = decoder.readByte();
            if (fileSnapshotKind == 1) {
                snapshots.put(key, new DefaultFileCollectionSnapshotter.DirSnapshot());
                continue;
            }
            if (fileSnapshotKind == 2) {
                snapshots.put(key, new DefaultFileCollectionSnapshotter.MissingFileSnapshot());
                continue;
            }
            if (fileSnapshotKind == 3) {
                byte hashSize = decoder.readByte();
                byte[] hash = new byte[hashSize];
                decoder.readBytes(hash);
                snapshots.put(key, new DefaultFileCollectionSnapshotter.FileHashSnapshot(hash));
                continue;
            }
            throw new RuntimeException("Unable to read serialized file collection snapshot. Unrecognized value found in the data stream.");
        }
        return snapshot;
    }

    public void write(Encoder encoder, DefaultFileCollectionSnapshotter.FileCollectionSnapshotImpl value) throws Exception {
        encoder.writeSmallInt(value.snapshots.size());
        for (String key : value.snapshots.keySet()) {
            encoder.writeString((CharSequence)key);
            DefaultFileCollectionSnapshotter.FileSnapshot fileSnapshot = value.snapshots.get(key);
            if (fileSnapshot instanceof DefaultFileCollectionSnapshotter.DirSnapshot) {
                encoder.writeByte((byte)1);
                continue;
            }
            if (fileSnapshot instanceof DefaultFileCollectionSnapshotter.MissingFileSnapshot) {
                encoder.writeByte((byte)2);
                continue;
            }
            if (!(fileSnapshot instanceof DefaultFileCollectionSnapshotter.FileHashSnapshot)) continue;
            encoder.writeByte((byte)3);
            byte[] hash = ((DefaultFileCollectionSnapshotter.FileHashSnapshot)fileSnapshot).hash;
            encoder.writeByte((byte)hash.length);
            encoder.writeBytes(hash);
        }
    }
}

