/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.InputFileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.util.ChangeListener;

class InputFilesStateChangeRule {
    InputFilesStateChangeRule() {
    }

    public static TaskStateChanges create(TaskInternal task, final TaskExecution previousExecution, final TaskExecution currentExecution, FileCollectionSnapshotter inputFilesSnapshotter) {
        final FileCollectionSnapshot inputFilesSnapshot = inputFilesSnapshotter.snapshot(task.getInputs().getFiles());
        return new TaskStateChanges(){

            @Override
            public Iterator<TaskStateChange> iterator() {
                if (previousExecution.getInputFilesSnapshot() == null) {
                    return Collections.singleton(new DescriptiveChange("Input file history is not available.", new Object[0])).iterator();
                }
                return new AbstractIterator<TaskStateChange>(){
                    final FileCollectionSnapshot.ChangeIterator<String> changeIterator;
                    final ChangeListenerAdapter listenerAdapter;
                    {
                        this.changeIterator = inputFilesSnapshot.iterateChangesSince(previousExecution.getInputFilesSnapshot());
                        this.listenerAdapter = new ChangeListenerAdapter();
                    }

                    protected TaskStateChange computeNext() {
                        if (this.changeIterator.next(this.listenerAdapter)) {
                            return this.listenerAdapter.lastChange;
                        }
                        return (TaskStateChange)this.endOfData();
                    }
                };
            }

            @Override
            public void snapshotAfterTask() {
                currentExecution.setInputFilesSnapshot(inputFilesSnapshot);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeListenerAdapter
    implements ChangeListener<String> {
        public InputFileChange lastChange;

        private ChangeListenerAdapter() {
        }

        @Override
        public void added(String fileName) {
            this.lastChange = new InputFileChange(fileName, ChangeType.ADDED);
        }

        @Override
        public void removed(String fileName) {
            this.lastChange = new InputFileChange(fileName, ChangeType.REMOVED);
        }

        @Override
        public void changed(String fileName) {
            this.lastChange = new InputFileChange(fileName, ChangeType.MODIFIED);
        }
    }
}

