/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.model.ModelRule;
import org.gradle.model.ModelRules;
import org.gradle.model.internal.Inputs;
import org.gradle.model.internal.ModelCreator;
import org.gradle.model.internal.ModelMutator;
import org.gradle.model.internal.ModelRegistry;
import org.gradle.model.internal.rules.ReflectiveRule;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRegistryBackedModelRules
implements ModelRules {
    private final ModelRegistry modelRegistry;

    public ModelRegistryBackedModelRules(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    @Override
    public <T> void register(String path, T model) {
        Class<?> aClass = model.getClass();
        this.register(path, aClass, Factories.constant(model));
    }

    @Override
    public <T> void register(String path, final Class<T> type, final Factory<? extends T> model) {
        this.modelRegistry.create(path, (List<String>)ImmutableList.of(), new ModelCreator<T>(){

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public T create(Inputs inputs) {
                return model.create();
            }
        });
    }

    @Override
    public void remove(String path) {
        this.modelRegistry.remove(path);
    }

    @Override
    public void rule(ModelRule rule) {
        ReflectiveRule.rule(this.modelRegistry, rule);
    }

    @Override
    public <T> void config(String path, Action<T> action) {
        Class<T> modelType = this.getActionObjectType(action);
        this.modelRegistry.mutate(path, Collections.<String>emptyList(), ActionBackedModelMutator.create(modelType, action));
    }

    private <T> Class<T> getActionObjectType(Action<T> action) {
        Class modelType;
        Class<?> aClass = action.getClass();
        Object[] genericInterfaces = aClass.getGenericInterfaces();
        Type actionType = (Type)CollectionUtils.findFirst((Object[])genericInterfaces, (Spec)new Spec<Type>(){

            public boolean isSatisfiedBy(Type element) {
                return element instanceof ParameterizedType && ((ParameterizedType)element).getRawType().equals(Action.class);
            }
        });
        if (actionType == null) {
            modelType = Object.class;
        } else {
            ParameterizedType actionParamaterizedType = (ParameterizedType)actionType;
            Type tType = actionParamaterizedType.getActualTypeArguments()[0];
            if (tType instanceof Class) {
                modelType = (Class)tType;
            } else if (tType instanceof ParameterizedType) {
                modelType = (Class)((ParameterizedType)tType).getRawType();
            } else {
                if (tType instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)tType;
                    Type[] bounds = typeVariable.getBounds();
                    return (Class)bounds[0];
                }
                throw new RuntimeException("Don't know how to handle type: " + tType.getClass());
            }
        }
        Class castModelType = modelType;
        return castModelType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionBackedModelMutator<T>
    implements ModelMutator<T> {
        private final Class<T> modelType;
        private final Action<T> action;

        public static <T> ModelMutator<T> create(Class<T> type, Action<T> action) {
            return new ActionBackedModelMutator<T>(type, action);
        }

        public ActionBackedModelMutator(Class<T> modelType, Action<T> action) {
            this.modelType = modelType;
            this.action = action;
        }

        @Override
        public Class<T> getType() {
            return this.modelType;
        }

        @Override
        public void mutate(T object, Inputs inputs) {
            this.action.execute(object);
        }
    }
}

