/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Multimap;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelector;
import org.gradle.execution.commandline.CommandLineTaskParser;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolvingBuildConfigurationAction
implements BuildConfigurationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskNameResolvingBuildConfigurationAction.class);
    private final TaskNameResolver taskNameResolver;

    public TaskNameResolvingBuildConfigurationAction() {
        this(new TaskNameResolver());
    }

    TaskNameResolvingBuildConfigurationAction(TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
    }

    @Override
    public void configure(BuildExecutionContext context) {
        GradleInternal gradle = context.getGradle();
        List<String> taskNames = gradle.getStartParameter().getTaskNames();
        Multimap<String, Task> selectedTasks = this.doSelect(gradle, taskNames, this.taskNameResolver);
        TaskGraphExecuter executer = gradle.getTaskGraph();
        for (String name : selectedTasks.keySet()) {
            executer.addTasks(selectedTasks.get((Object)name));
        }
        if (selectedTasks.keySet().size() == 1) {
            LOGGER.info("Selected primary task {}", (Object)GUtil.toString(selectedTasks.keySet()));
        } else {
            LOGGER.info("Selected primary tasks {}", (Object)GUtil.toString(selectedTasks.keySet()));
        }
        context.proceed();
    }

    private Multimap<String, Task> doSelect(GradleInternal gradle, List<String> paths, TaskNameResolver taskNameResolver) {
        TaskSelector selector = new TaskSelector(gradle, taskNameResolver);
        return new CommandLineTaskParser().parseTasks(paths, selector);
    }
}

