/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.DefaultLockStateSerializer;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockStateSerializer;
import org.gradle.cache.internal.filelock.Version1LockStateSerializer;

public class LockOptionsBuilder
implements LockOptions {
    private FileLockManager.LockMode mode;
    private boolean simple;

    private LockOptionsBuilder(FileLockManager.LockMode mode, boolean simple) {
        this.mode = mode;
        this.simple = simple;
    }

    public static LockOptionsBuilder mode(FileLockManager.LockMode lockMode) {
        return new LockOptionsBuilder(lockMode, false);
    }

    public LockOptionsBuilder simple() {
        this.simple = true;
        return this;
    }

    public FileLockManager.LockMode getMode() {
        return this.mode;
    }

    public LockStateSerializer getLockStateSerializer() {
        return this.simple ? new Version1LockStateSerializer() : new DefaultLockStateSerializer();
    }

    public LockOptions withMode(FileLockManager.LockMode mode) {
        return LockOptionsBuilder.mode(mode).simple(this.simple);
    }

    private LockOptions simple(boolean simple) {
        this.simple = simple;
        return this;
    }

    public String toString() {
        return (Object)((Object)this.mode) + " (simple=" + this.simple + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LockOptionsBuilder)) {
            return false;
        }
        LockOptionsBuilder that = (LockOptionsBuilder)o;
        if (this.simple != that.simple) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + (this.simple ? 1 : 0);
        return result;
    }
}

