/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.api.internal.Transformers;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentIndexedCacheParameters<K, V> {
    private final File cacheFile;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private Transformer<MultiProcessSafePersistentIndexedCache<K, V>, MultiProcessSafePersistentIndexedCache<K, V>> cacheDecorator = Transformers.noOpTransformer();

    public PersistentIndexedCacheParameters(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cacheFile = cacheFile;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public PersistentIndexedCacheParameters(File cacheFile, Class<K> keyType, Serializer<V> valueSerializer) {
        this(cacheFile, (Serializer<K>)new DefaultSerializer(keyType.getClassLoader()), valueSerializer);
    }

    public PersistentIndexedCacheParameters(File cacheFile, Class<K> keyType, Class<V> valueType) {
        this(cacheFile, keyType, (Serializer<V>)new DefaultSerializer(valueType.getClassLoader()));
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public PersistentIndexedCacheParameters cacheDecorator(Transformer<MultiProcessSafePersistentIndexedCache<K, V>, MultiProcessSafePersistentIndexedCache<K, V>> cacheDecorator) {
        assert (cacheDecorator != null);
        this.cacheDecorator = cacheDecorator;
        return this;
    }

    public MultiProcessSafePersistentIndexedCache<K, V> decorate(MultiProcessSafePersistentIndexedCache<K, V> input) {
        return (MultiProcessSafePersistentIndexedCache)this.cacheDecorator.transform(input);
    }
}

