/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileIntegrityViolationException;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.InsufficientLockModeException;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.ProcessMetaDataProvider;
import org.gradle.cache.internal.filelock.LockFileAccess;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateAccess;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Factory;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.NoZeroIntegerIdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileLockManager
implements FileLockManager {
    private static final Logger LOGGER = Logging.getLogger(DefaultFileLockManager.class);
    public static final int DEFAULT_LOCK_TIMEOUT = 60000;
    private final Set<File> lockedFiles = new CopyOnWriteArraySet<File>();
    private final ProcessMetaDataProvider metaDataProvider;
    private final int lockTimeoutMs;
    private final IdGenerator<Long> generator;
    private final FileLockContentionHandler fileLockContentionHandler;
    private final long shortTimeoutMs = 10000L;
    private final int ownerId = new NoZeroIntegerIdGenerator().generateId();

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, FileLockContentionHandler fileLockContentionHandler) {
        this(metaDataProvider, 60000, fileLockContentionHandler);
    }

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs, FileLockContentionHandler fileLockContentionHandler) {
        this(metaDataProvider, lockTimeoutMs, fileLockContentionHandler, (IdGenerator<Long>)new RandomLongIdGenerator());
    }

    DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs, FileLockContentionHandler fileLockContentionHandler, IdGenerator<Long> generator) {
        this.metaDataProvider = metaDataProvider;
        this.lockTimeoutMs = lockTimeoutMs;
        this.fileLockContentionHandler = fileLockContentionHandler;
        this.generator = generator;
    }

    @Override
    public FileLock lock(File target, LockOptions options, String targetDisplayName) throws LockTimeoutException {
        return this.lock(target, options, targetDisplayName, "");
    }

    @Override
    public FileLock lock(File target, LockOptions options, String targetDisplayName, String operationDisplayName) {
        if (options.getMode() == FileLockManager.LockMode.None) {
            throw new UnsupportedOperationException(String.format("No %s mode lock implementation available.", options));
        }
        File canonicalTarget = GFileUtils.canonicalise(target);
        if (!this.lockedFiles.add(canonicalTarget)) {
            throw new IllegalStateException(String.format("Cannot lock %s as it has already been locked by this process.", targetDisplayName));
        }
        try {
            int port = this.fileLockContentionHandler.reservePort();
            return new DefaultFileLock(canonicalTarget, options, targetDisplayName, operationDisplayName, port);
        }
        catch (Throwable t) {
            this.lockedFiles.remove(canonicalTarget);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    @Override
    public void allowContention(FileLock fileLock, Runnable whenContended) {
        DefaultFileLock internalLock = (DefaultFileLock)fileLock;
        this.fileLockContentionHandler.start(internalLock.lockId, whenContended);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultFileLock
    extends AbstractFileAccess
    implements FileLock {
        private final File lockFile;
        private final File target;
        private final FileLockManager.LockMode mode;
        private final String displayName;
        private final String operationDisplayName;
        private java.nio.channels.FileLock lock;
        private LockFileAccess lockFileAccess;
        private LockState lockState;
        private int port;
        private final long lockId;

        public DefaultFileLock(File target, LockOptions options, String displayName, String operationDisplayName, int port) throws Throwable {
            this.port = port;
            this.lockId = (Long)DefaultFileLockManager.this.generator.generateId();
            if (options.getMode() == FileLockManager.LockMode.None) {
                throw new UnsupportedOperationException("Locking mode None is not supported.");
            }
            this.target = target;
            this.displayName = displayName;
            this.operationDisplayName = operationDisplayName;
            this.lockFile = target.isDirectory() ? new File(target, target.getName() + ".lock") : new File(target.getParentFile(), target.getName() + ".lock");
            GFileUtils.mkdirs(this.lockFile.getParentFile());
            this.lockFile.createNewFile();
            this.lockFileAccess = new LockFileAccess(this.lockFile, new LockStateAccess(options.getLockStateSerializer()));
            try {
                this.lockState = this.lock(options.getMode());
            }
            catch (Throwable t) {
                this.lockFileAccess.close();
                throw t;
            }
            this.mode = this.lock.isShared() ? FileLockManager.LockMode.Shared : FileLockManager.LockMode.Exclusive;
        }

        @Override
        public boolean isLockFile(File file) {
            return file.equals(this.lockFile);
        }

        @Override
        public boolean getUnlockedCleanly() {
            this.assertOpen();
            return !this.lockState.isDirty();
        }

        @Override
        public FileLock.State getState() {
            this.assertOpen();
            return this.lockState;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            return (T)action.create();
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            this.doWriteAction(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            this.assertOpen();
            this.doWriteAction(action);
        }

        private void doWriteAction(Runnable action) {
            if (this.mode != FileLockManager.LockMode.Exclusive) {
                throw new InsufficientLockModeException("An exclusive lock is required for this operation");
            }
            try {
                this.lockState = this.lockFileAccess.markDirty(this.lockState);
                action.run();
                this.lockState = this.lockFileAccess.markClean(this.lockState);
            }
            catch (Throwable t) {
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
        }

        private void assertOpen() {
            if (this.lock == null) {
                throw new IllegalStateException("This lock has been closed.");
            }
        }

        private void assertOpenAndIntegral() {
            this.assertOpen();
            if (this.lockState.isDirty()) {
                throw new FileIntegrityViolationException(String.format("The file '%s' was not unlocked cleanly", this.target));
            }
        }

        @Override
        public void close() {
            CompositeStoppable stoppable = new CompositeStoppable();
            stoppable.add(new Object[]{new Stoppable(){

                public void stop() {
                    try {
                        DefaultFileLockManager.this.fileLockContentionHandler.stop(DefaultFileLock.this.lockId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to stop listening for file lock requests for " + DefaultFileLock.this.displayName, e);
                    }
                }
            }});
            stoppable.add(new Object[]{new Stoppable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stop() {
                    block11: {
                        if (DefaultFileLock.this.lockFileAccess == null) {
                            return;
                        }
                        try {
                            LOGGER.debug("Releasing lock on {}.", DefaultFileLock.this.displayName);
                            try {
                                java.nio.channels.FileLock info;
                                if (DefaultFileLock.this.lock == null || DefaultFileLock.this.lock.isShared()) break block11;
                                try {
                                    info = DefaultFileLock.this.lockInformationRegion(FileLockManager.LockMode.Exclusive, System.currentTimeMillis() + 10000L);
                                }
                                catch (InterruptedException e) {
                                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                                }
                                if (info == null) break block11;
                                try {
                                    DefaultFileLock.this.lockFileAccess.clearLockInfo();
                                }
                                finally {
                                    info.release();
                                }
                            }
                            finally {
                                DefaultFileLock.this.lockFileAccess.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to release lock on " + DefaultFileLock.this.displayName, e);
                        }
                    }
                }
            }});
            stoppable.add(new Object[]{new Stoppable(){

                public void stop() {
                    DefaultFileLock.this.lock = null;
                    DefaultFileLock.this.lockFileAccess = null;
                    DefaultFileLockManager.this.lockedFiles.remove(DefaultFileLock.this.target);
                }
            }});
            stoppable.stop();
        }

        @Override
        public FileLockManager.LockMode getMode() {
            return this.mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockState lock(FileLockManager.LockMode lockMode) throws Throwable {
            LOGGER.debug("Waiting to acquire {} lock on {}.", lockMode.toString().toLowerCase(), this.displayName);
            long waitUntil = System.currentTimeMillis() + (long)DefaultFileLockManager.this.lockTimeoutMs;
            java.nio.channels.FileLock stateRegionLock = this.lockStateRegion(lockMode, waitUntil);
            if (stateRegionLock == null) {
                LockInfo lockInfo = this.readInformationRegion(System.currentTimeMillis() + 10000L);
                throw new LockTimeoutException(String.format("Timeout waiting to lock %s. It is currently in use by another Gradle instance.%nOwner PID: %s%nOur PID: %s%nOwner Operation: %s%nOur operation: %s%nLock file: %s", this.displayName, lockInfo.pid, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), lockInfo.operation, this.operationDisplayName, this.lockFile));
            }
            try {
                LockState lockState;
                if (!stateRegionLock.isShared()) {
                    lockState = this.lockFileAccess.ensureLockState();
                    java.nio.channels.FileLock informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, System.currentTimeMillis() + 10000L);
                    if (informationRegionLock == null) {
                        throw new IllegalStateException(String.format("Unable to lock the information region for %s", this.displayName));
                    }
                    try {
                        this.lockFileAccess.writeLockInfo(this.port, this.lockId, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), this.operationDisplayName);
                    }
                    finally {
                        informationRegionLock.release();
                    }
                } else {
                    lockState = this.lockFileAccess.readLockState();
                }
                LOGGER.debug("Lock acquired.");
                this.lock = stateRegionLock;
                return lockState;
            }
            catch (Throwable t) {
                stateRegionLock.release();
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockInfo readInformationRegion(long waitUntil) throws IOException, InterruptedException {
            LockInfo out = new LockInfo();
            java.nio.channels.FileLock informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Shared, waitUntil);
            if (informationRegionLock == null) {
                LOGGER.debug("Could not lock information region for {}. Ignoring.", this.displayName);
            } else {
                try {
                    out = this.lockFileAccess.readLockInfo();
                }
                finally {
                    informationRegionLock.release();
                }
            }
            return out;
        }

        private java.nio.channels.FileLock lockStateRegion(FileLockManager.LockMode lockMode, long waitUntil) throws IOException, InterruptedException {
            do {
                java.nio.channels.FileLock fileLock;
                if ((fileLock = this.lockFileAccess.tryLockState(lockMode == FileLockManager.LockMode.Shared)) != null) {
                    return fileLock;
                }
                if (this.port != -1) {
                    LockInfo lockInfo = this.readInformationRegion(System.currentTimeMillis());
                    if (lockInfo.port != -1) {
                        LOGGER.debug("The file lock is held by a different Gradle process (pid: {}, operation: {}). Will attempt to ping owner at port {}", lockInfo.pid, lockInfo.operation, lockInfo.port);
                        DefaultFileLockManager.this.fileLockContentionHandler.pingOwner(lockInfo.port, lockInfo.lockId, this.displayName);
                    } else {
                        LOGGER.debug("The file lock is held by a different Gradle process. I was unable to read on which port the owner listens for lock access requests.");
                    }
                }
                Thread.sleep(200L);
            } while (System.currentTimeMillis() < waitUntil);
            return null;
        }

        private java.nio.channels.FileLock lockInformationRegion(FileLockManager.LockMode lockMode, long waitUntil) throws IOException, InterruptedException {
            do {
                java.nio.channels.FileLock fileLock;
                if ((fileLock = this.lockFileAccess.tryLockInfo(lockMode == FileLockManager.LockMode.Shared)) != null) {
                    return fileLock;
                }
                Thread.sleep(200L);
            } while (System.currentTimeMillis() < waitUntil);
            return null;
        }
    }
}

