/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.xml;

import groovy.lang.Closure;
import groovy.util.IndentPrinter;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.DomNode;
import org.gradle.api.internal.IoActions;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GUtil;
import org.gradle.util.TextUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTransformer
implements Transformer<String, String> {
    private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
    private String indentation = "  ";

    public void addAction(Action<? super XmlProvider> provider) {
        this.actions.add(provider);
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public void addAction(Closure closure) {
        this.actions.add(new ClosureBackedAction(closure));
    }

    public void transform(File destination, final String encoding, final Action<? super Writer> generator) {
        IoActions.writeTextFile((File)destination, (String)encoding, (Action)new Action<Writer>(){

            public void execute(Writer writer) {
                XmlTransformer.this.transform(writer, encoding, (Action<? super Writer>)generator);
            }
        });
    }

    public void transform(File destination, final Action<? super Writer> generator) {
        IoActions.writeTextFile((File)destination, (Action)new Action<Writer>(){

            public void execute(Writer writer) {
                XmlTransformer.this.transform(writer, (Action<? super Writer>)generator);
            }
        });
    }

    public void transform(Writer destination, Action<? super Writer> generator) {
        StringWriter stringWriter = new StringWriter();
        generator.execute((Object)stringWriter);
        this.transform(stringWriter.toString(), destination);
    }

    public void transform(Writer destination, String encoding, Action<? super Writer> generator) {
        StringWriter stringWriter = new StringWriter();
        generator.execute((Object)stringWriter);
        this.doTransform(stringWriter.toString()).writeTo(destination, encoding);
    }

    public String transform(String original) {
        return this.doTransform(original).toString();
    }

    public void transform(String original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(String original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(Node original, File destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(DomNode original, Writer destination) {
        this.doTransform(original).writeTo(destination);
    }

    public void transform(DomNode original, OutputStream destination) {
        this.doTransform(original).writeTo(destination);
    }

    private XmlProviderImpl doTransform(String original) {
        return this.doTransform(new XmlProviderImpl(original));
    }

    private XmlProviderImpl doTransform(Node original) {
        return this.doTransform(new XmlProviderImpl(original));
    }

    private XmlProviderImpl doTransform(DomNode original) {
        return this.doTransform(new XmlProviderImpl(original));
    }

    private XmlProviderImpl doTransform(XmlProviderImpl provider) {
        provider.apply(this.actions);
        return provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmlProviderImpl
    implements XmlProvider {
        private StringBuilder builder;
        private Node node;
        private String stringValue;
        private Element element;
        private String publicId;
        private String systemId;

        public XmlProviderImpl(String original) {
            this.stringValue = original;
        }

        public XmlProviderImpl(Node original) {
            this.node = original;
        }

        public XmlProviderImpl(DomNode original) {
            this.node = original;
            this.publicId = original.getPublicId();
            this.systemId = original.getSystemId();
        }

        public void apply(Iterable<Action<? super XmlProvider>> actions) {
            for (Action<? super XmlProvider> action : actions) {
                action.execute((Object)this);
            }
        }

        public String toString() {
            StringWriter writer = new StringWriter();
            this.writeTo(writer);
            return writer.toString();
        }

        public void writeTo(Writer writer) {
            this.doWriteTo(writer, null);
        }

        public void writeTo(Writer writer, String encoding) {
            this.doWriteTo(writer, encoding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(File file) {
            try {
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    this.writeTo(outputStream);
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public void writeTo(OutputStream stream) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                this.doWriteTo(writer, "UTF-8");
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        @Override
        public StringBuilder asString() {
            if (this.builder == null) {
                this.builder = new StringBuilder(this.toString());
                this.node = null;
                this.element = null;
            }
            return this.builder;
        }

        @Override
        public Node asNode() {
            if (this.node == null) {
                try {
                    this.node = new XmlParser().parseText(this.toString());
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                this.builder = null;
                this.element = null;
            }
            return this.node;
        }

        @Override
        public Element asElement() {
            if (this.element == null) {
                Document document;
                try {
                    document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(this.toString())));
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                this.element = document.getDocumentElement();
                this.builder = null;
                this.node = null;
            }
            return this.element;
        }

        private void doWriteTo(Writer writer, String encoding) {
            this.writeXmlDeclaration(writer, encoding);
            try {
                if (this.node != null) {
                    this.printNode(this.node, writer);
                } else if (this.element != null) {
                    this.printDomNode(this.element, writer);
                } else if (this.builder != null) {
                    writer.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.builder)));
                } else {
                    writer.append(TextUtil.toPlatformLineSeparators(this.stripXmlDeclaration(this.stringValue)));
                }
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private void printNode(Node node, Writer writer) {
            final PrintWriter printWriter = new PrintWriter(writer);
            if (GUtil.isTrue(this.publicId)) {
                printWriter.format("<!DOCTYPE %s PUBLIC \"%s\" \"%s\">%n", node.name(), this.publicId, this.systemId);
            }
            IndentPrinter indentPrinter = new IndentPrinter(printWriter, XmlTransformer.this.indentation){

                public void println() {
                    printWriter.println();
                }
            };
            XmlNodePrinter nodePrinter = new XmlNodePrinter(indentPrinter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(node);
            printWriter.flush();
        }

        private void printDomNode(org.w3c.dom.Node node, Writer destination) {
            this.removeEmptyTextNodes(node);
            int indentAmount = this.determineIndentAmount();
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                try {
                    factory.setAttribute("indent-number", indentAmount);
                }
                catch (IllegalArgumentException ignored) {
                    // empty catch block
                }
                javax.xml.transform.Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                if (GUtil.isTrue(this.publicId)) {
                    transformer.setOutputProperty("doctype-public", this.publicId);
                    transformer.setOutputProperty("doctype-system", this.systemId);
                }
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentAmount));
                }
                catch (IllegalArgumentException ignored) {
                    // empty catch block
                }
                transformer.transform(new DOMSource(node), new StreamResult(destination));
            }
            catch (TransformerException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private int determineIndentAmount() {
            if (XmlTransformer.this.indentation.equals("\t")) {
                return 2;
            }
            return XmlTransformer.this.indentation.length();
        }

        private void removeEmptyTextNodes(org.w3c.dom.Node node) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node child = children.item(i);
                if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                    node.removeChild(child);
                    continue;
                }
                this.removeEmptyTextNodes(child);
            }
        }

        private void writeXmlDeclaration(Writer writer, String encoding) {
            try {
                writer.write("<?xml version=\"1.0\"");
                if (encoding != null) {
                    writer.write(" encoding=\"");
                    writer.write(encoding);
                    writer.write("\"");
                }
                writer.write("?>");
                writer.write(SystemProperties.getLineSeparator());
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private boolean hasXmlDeclaration(String xml) {
            return xml.startsWith("<?xml");
        }

        private String stripXmlDeclaration(CharSequence sequence) {
            String str = sequence.toString();
            if (this.hasXmlDeclaration(str)) {
                str = str.substring(str.indexOf("?>") + 2);
                str = StringUtils.stripStart((String)str, null);
            }
            return str;
        }
    }
}

