/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.concurrent.TimeUnit;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.notations.parsers.NormalizedTimeUnit;

public class TimeUnitsParser {
    public NormalizedTimeUnit parseNotation(CharSequence notation, int value) {
        String candidate = notation.toString().toUpperCase();
        if (candidate.equals("DAYS")) {
            return NormalizedTimeUnit.millis(value * 24 * 60 * 60 * 1000);
        }
        if (candidate.equals("HOURS")) {
            return NormalizedTimeUnit.millis(value * 60 * 60 * 1000);
        }
        if (candidate.equals("MINUTES")) {
            return NormalizedTimeUnit.millis(value * 60 * 1000);
        }
        try {
            return new NormalizedTimeUnit(value, TimeUnit.valueOf(candidate));
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Unable to parse provided TimeUnit: " + notation, e);
        }
    }
}

