/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameOnlyPatternMatcher
implements Spec<RelativePath> {
    private boolean partialMatchDirs;
    private PatternStep nameStep;

    public NameOnlyPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String pattern) {
        this.partialMatchDirs = partialMatchDirs;
        this.nameStep = PatternStepFactory.getStep(pattern, true, caseSensitive);
    }

    public boolean isSatisfiedBy(RelativePath path) {
        if (!path.isFile()) {
            return this.partialMatchDirs;
        }
        String lastName = path.getLastName();
        if (lastName == null) {
            return false;
        }
        return this.nameStep.matches(lastName, true);
    }
}

