/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;

public class TarCopyAction
implements CopyAction {
    private final File tarFile;
    private final ArchiveOutputStreamFactory compressor;

    public TarCopyAction(File tarFile, ArchiveOutputStreamFactory compressor) {
        this.tarFile = tarFile;
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(CopyActionProcessingStream stream) {
        TarOutputStream tarOutStr;
        OutputStream outStr;
        try {
            outStr = this.compressor.createArchiveOutputStream(this.tarFile);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create TAR '%s'.", this.tarFile), (Throwable)e);
        }
        try {
            tarOutStr = new TarOutputStream(outStr);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((OutputStream)outStr);
            throw new GradleException(String.format("Could not create TAR '%s'.", this.tarFile), (Throwable)e);
        }
        tarOutStr.setLongFileMode(2);
        try {
            stream.process(new StreamAction(tarOutStr));
        }
        catch (Exception e) {
            UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)tarOutStr);
        }
        return new SimpleWorkResult(true);
    }

    private class StreamAction
    implements CopyActionProcessingStreamAction {
        private final TarOutputStream tarOutStr;

        public StreamAction(TarOutputStream tarOutStr) {
            this.tarOutStr = tarOutStr;
        }

        public void processFile(FileCopyDetailsInternal details) {
            if (details.isDirectory()) {
                this.visitDir(details);
            } else {
                this.visitFile(details);
            }
        }

        private void visitFile(FileCopyDetails fileDetails) {
            try {
                TarEntry archiveEntry = new TarEntry(fileDetails.getRelativePath().getPathString());
                archiveEntry.setModTime(fileDetails.getLastModified());
                archiveEntry.setSize(fileDetails.getSize());
                archiveEntry.setMode(0x8000 | fileDetails.getMode());
                this.tarOutStr.putNextEntry(archiveEntry);
                fileDetails.copyTo((OutputStream)this.tarOutStr);
                this.tarOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to TAR '%s'.", fileDetails, TarCopyAction.this.tarFile), (Throwable)e);
            }
        }

        private void visitDir(FileCopyDetails dirDetails) {
            try {
                TarEntry archiveEntry = new TarEntry(dirDetails.getRelativePath().getPathString() + '/');
                archiveEntry.setModTime(dirDetails.getLastModified());
                archiveEntry.setMode(0x4000 | dirDetails.getMode());
                this.tarOutStr.putNextEntry(archiveEntry);
                this.tarOutStr.closeEntry();
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not add %s to TAR '%s'.", dirDetails, TarCopyAction.this.tarFile), (Throwable)e);
            }
        }
    }
}

