/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotterSerializer;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSnapshotSerializer
implements Serializer<FileCollectionSnapshot> {
    private final DefaultFileSnapshotterSerializer defaultSnapshotSerializer = new DefaultFileSnapshotterSerializer();
    private final OutputFilesSnapshotSerializer outputSnapshotSerializer = new OutputFilesSnapshotSerializer();

    FileSnapshotSerializer() {
    }

    public FileCollectionSnapshot read(Decoder decoder) throws Exception {
        byte kind = decoder.readByte();
        if (kind == 1) {
            return this.defaultSnapshotSerializer.read(decoder);
        }
        if (kind == 2) {
            return this.outputSnapshotSerializer.read(decoder);
        }
        throw new RuntimeException("Unable to read from file snapshot cache. Unexpected value found in the data stream.");
    }

    public void write(Encoder encoder, FileCollectionSnapshot value) throws Exception {
        if (value instanceof DefaultFileSnapshotter.FileCollectionSnapshotImpl) {
            encoder.writeByte((byte)1);
            DefaultFileSnapshotter.FileCollectionSnapshotImpl cached = (DefaultFileSnapshotter.FileCollectionSnapshotImpl)value;
            this.defaultSnapshotSerializer.write(encoder, cached);
        } else if (value instanceof OutputFilesSnapshotter.OutputFilesSnapshot) {
            encoder.writeByte((byte)2);
            OutputFilesSnapshotter.OutputFilesSnapshot cached = (OutputFilesSnapshotter.OutputFilesSnapshot)value;
            this.outputSnapshotSerializer.write(encoder, cached);
        } else {
            throw new RuntimeException("Unable to write to file snapshot cache. Unexpected type to write: " + value);
        }
    }
}

