/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileSnapshotterSerializer
implements Serializer<FileCollectionSnapshot> {
    DefaultFileSnapshotterSerializer() {
    }

    public FileCollectionSnapshot read(Decoder decoder) throws Exception {
        HashMap<String, DefaultFileSnapshotter.FileSnapshot> snapshots = new HashMap<String, DefaultFileSnapshotter.FileSnapshot>();
        DefaultFileSnapshotter.FileCollectionSnapshotImpl snapshot = new DefaultFileSnapshotter.FileCollectionSnapshotImpl(snapshots);
        int snapshotsCount = decoder.readInt();
        for (int i = 0; i < snapshotsCount; ++i) {
            String key = decoder.readString();
            byte fileSnapshotKind = decoder.readByte();
            if (fileSnapshotKind == 1) {
                snapshots.put(key, new DefaultFileSnapshotter.DirSnapshot());
                continue;
            }
            if (fileSnapshotKind == 2) {
                snapshots.put(key, new DefaultFileSnapshotter.MissingFileSnapshot());
                continue;
            }
            if (fileSnapshotKind == 3) {
                byte hashSize = decoder.readByte();
                byte[] hash = new byte[hashSize];
                decoder.readBytes(hash);
                snapshots.put(key, new DefaultFileSnapshotter.FileHashSnapshot(hash));
                continue;
            }
            throw new RuntimeException("Unable to read serialized file collection snapshot. Unrecognized value found in the data stream.");
        }
        return snapshot;
    }

    public void write(Encoder encoder, FileCollectionSnapshot value) throws Exception {
        DefaultFileSnapshotter.FileCollectionSnapshotImpl cached = (DefaultFileSnapshotter.FileCollectionSnapshotImpl)value;
        encoder.writeInt(cached.snapshots.size());
        for (String key : cached.snapshots.keySet()) {
            encoder.writeString((CharSequence)key);
            DefaultFileSnapshotter.FileSnapshot fileSnapshot = cached.snapshots.get(key);
            if (fileSnapshot instanceof DefaultFileSnapshotter.DirSnapshot) {
                encoder.writeByte((byte)1);
                continue;
            }
            if (fileSnapshot instanceof DefaultFileSnapshotter.MissingFileSnapshot) {
                encoder.writeByte((byte)2);
                continue;
            }
            if (!(fileSnapshot instanceof DefaultFileSnapshotter.FileHashSnapshot)) continue;
            encoder.writeByte((byte)3);
            byte[] hash = ((DefaultFileSnapshotter.FileHashSnapshot)fileSnapshot).hash;
            encoder.writeByte((byte)hash.length);
            encoder.writeBytes(hash);
        }
    }
}

