/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.Hasher;
import org.gradle.api.internal.changedetection.state.MapMergeChangeListener;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.util.ChangeListener;
import org.gradle.util.NoOpChangeListener;

public class DefaultFileSnapshotter
implements FileSnapshotter {
    private final Hasher hasher;
    private TaskArtifactStateCacheAccess cacheAccess;

    public DefaultFileSnapshotter(Hasher hasher, TaskArtifactStateCacheAccess cacheAccess) {
        this.hasher = hasher;
        this.cacheAccess = cacheAccess;
    }

    public FileCollectionSnapshot emptySnapshot() {
        return new FileCollectionSnapshotImpl(new HashMap<String, FileSnapshot>());
    }

    public FileCollectionSnapshot snapshot(FileCollection sourceFiles) {
        final HashMap<String, FileSnapshot> snapshots = new HashMap<String, FileSnapshot>();
        final Set<File> theFiles = sourceFiles.getAsFileTree().getFiles();
        this.cacheAccess.useCache("Create file snapshot", new Runnable(){

            public void run() {
                for (File file : theFiles) {
                    if (file.isFile()) {
                        snapshots.put(file.getAbsolutePath(), new FileHashSnapshot(DefaultFileSnapshotter.this.hasher.hash(file)));
                        continue;
                    }
                    if (file.isDirectory()) {
                        snapshots.put(file.getAbsolutePath(), new DirSnapshot());
                        continue;
                    }
                    snapshots.put(file.getAbsolutePath(), new MissingFileSnapshot());
                }
            }
        });
        return new FileCollectionSnapshotImpl(snapshots);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileCollectionSnapshotImpl
    implements FileCollectionSnapshot {
        final Map<String, FileSnapshot> snapshots;

        public FileCollectionSnapshotImpl(Map<String, FileSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        @Override
        public FileCollection getFiles() {
            ArrayList<File> files = new ArrayList<File>();
            for (Map.Entry<String, FileSnapshot> entry : this.snapshots.entrySet()) {
                if (!(entry.getValue() instanceof FileHashSnapshot)) continue;
                files.add(new File(entry.getKey()));
            }
            return new SimpleFileCollection(files);
        }

        @Override
        public FileCollectionSnapshot.ChangeIterator<String> iterateChangesSince(FileCollectionSnapshot oldSnapshot) {
            FileCollectionSnapshotImpl other = (FileCollectionSnapshotImpl)oldSnapshot;
            final HashMap<String, FileSnapshot> otherSnapshots = new HashMap<String, FileSnapshot>(other.snapshots);
            final Iterator<String> currentFiles = this.snapshots.keySet().iterator();
            return new FileCollectionSnapshot.ChangeIterator<String>(){
                private Iterator<String> removedFiles;

                @Override
                public boolean next(ChangeListener<String> listener) {
                    while (currentFiles.hasNext()) {
                        String currentFile = (String)currentFiles.next();
                        FileSnapshot otherFile = (FileSnapshot)otherSnapshots.remove(currentFile);
                        if (otherFile == null) {
                            listener.added(currentFile);
                            return true;
                        }
                        if (FileCollectionSnapshotImpl.this.snapshots.get(currentFile).isUpToDate(otherFile)) continue;
                        listener.changed(currentFile);
                        return true;
                    }
                    if (this.removedFiles == null) {
                        this.removedFiles = otherSnapshots.keySet().iterator();
                    }
                    if (this.removedFiles.hasNext()) {
                        listener.removed(this.removedFiles.next());
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot oldSnapshot) {
            final FileCollectionSnapshotImpl other = (FileCollectionSnapshotImpl)oldSnapshot;
            return new FileCollectionSnapshot.Diff(){

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot) {
                    return this.applyTo(snapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
                }

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot, ChangeListener<FileCollectionSnapshot.Merge> listener) {
                    FileCollectionSnapshotImpl target = (FileCollectionSnapshotImpl)snapshot;
                    HashMap<String, FileSnapshot> newSnapshots = new HashMap<String, FileSnapshot>(target.snapshots);
                    FileCollectionSnapshotImpl.this.diff(FileCollectionSnapshotImpl.this.snapshots, other.snapshots, new MapMergeChangeListener<String, FileSnapshot>(listener, newSnapshots));
                    return new FileCollectionSnapshotImpl(newSnapshots);
                }
            };
        }

        private void diff(Map<String, FileSnapshot> snapshots, Map<String, FileSnapshot> oldSnapshots, ChangeListener<Map.Entry<String, FileSnapshot>> listener) {
            HashMap<String, FileSnapshot> otherSnapshots = new HashMap<String, FileSnapshot>(oldSnapshots);
            for (Map.Entry<String, FileSnapshot> entry : snapshots.entrySet()) {
                FileSnapshot otherFile = (FileSnapshot)otherSnapshots.remove(entry.getKey());
                if (otherFile == null) {
                    listener.added(entry);
                    continue;
                }
                if (entry.getValue().isUpToDate(otherFile)) continue;
                listener.changed(entry);
            }
            for (Map.Entry<String, FileSnapshot> entry : otherSnapshots.entrySet()) {
                listener.removed(entry);
            }
        }
    }

    static class MissingFileSnapshot
    implements FileSnapshot {
        MissingFileSnapshot() {
        }

        public boolean isUpToDate(FileSnapshot snapshot) {
            return snapshot instanceof MissingFileSnapshot;
        }
    }

    static class DirSnapshot
    implements FileSnapshot {
        DirSnapshot() {
        }

        public boolean isUpToDate(FileSnapshot snapshot) {
            return snapshot instanceof DirSnapshot;
        }
    }

    static class FileHashSnapshot
    implements FileSnapshot {
        final byte[] hash;

        public FileHashSnapshot(byte[] hash) {
            this.hash = hash;
        }

        public boolean isUpToDate(FileSnapshot snapshot) {
            if (!(snapshot instanceof FileHashSnapshot)) {
                return false;
            }
            FileHashSnapshot other = (FileHashSnapshot)snapshot;
            return Arrays.equals(this.hash, other.hash);
        }

        public String toString() {
            return new BigInteger(1, this.hash).toString(16);
        }
    }

    static interface FileSnapshot {
        public boolean isUpToDate(FileSnapshot var1);
    }
}

