/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.OutputFileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.util.ChangeListener;

class OutputFilesStateChangeRule {
    OutputFilesStateChangeRule() {
    }

    public static TaskStateChanges create(final TaskInternal task, final TaskExecution previousExecution, final TaskExecution currentExecution, final FileSnapshotter outputFilesSnapshotter) {
        final FileCollectionSnapshot outputFilesBefore = outputFilesSnapshotter.snapshot(task.getOutputs().getFiles());
        return new TaskStateChanges(){

            @Override
            public Iterator<TaskStateChange> iterator() {
                if (previousExecution.getOutputFilesSnapshot() == null) {
                    return Collections.singleton(new DescriptiveChange("Output file history is not available.", new Object[0])).iterator();
                }
                return new AbstractIterator<TaskStateChange>(){
                    final FileCollectionSnapshot.ChangeIterator<String> changeIterator;
                    final ChangeListenerAdapter listenerAdapter;
                    {
                        this.changeIterator = outputFilesBefore.iterateChangesSince(previousExecution.getOutputFilesSnapshot());
                        this.listenerAdapter = new ChangeListenerAdapter();
                    }

                    protected TaskStateChange computeNext() {
                        if (this.changeIterator.next(this.listenerAdapter)) {
                            return this.listenerAdapter.lastChange;
                        }
                        return (TaskStateChange)this.endOfData();
                    }
                };
            }

            @Override
            public void snapshotAfterTask() {
                FileCollectionSnapshot lastExecutionOutputFiles = previousExecution == null || previousExecution.getOutputFilesSnapshot() == null ? outputFilesSnapshotter.emptySnapshot() : previousExecution.getOutputFilesSnapshot();
                FileCollectionSnapshot newOutputFiles = outputFilesBefore.changesSince(lastExecutionOutputFiles).applyTo(lastExecutionOutputFiles, new ChangeListener<FileCollectionSnapshot.Merge>(){

                    @Override
                    public void added(FileCollectionSnapshot.Merge element) {
                        element.ignore();
                    }

                    @Override
                    public void removed(FileCollectionSnapshot.Merge element) {
                    }

                    @Override
                    public void changed(FileCollectionSnapshot.Merge element) {
                    }
                });
                FileCollectionSnapshot outputFilesAfter = outputFilesSnapshotter.snapshot(task.getOutputs().getFiles());
                currentExecution.setOutputFilesSnapshot(outputFilesAfter.changesSince(outputFilesBefore).applyTo(newOutputFiles));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeListenerAdapter
    implements ChangeListener<String> {
        public OutputFileChange lastChange;

        private ChangeListenerAdapter() {
        }

        @Override
        public void added(String fileName) {
            this.lastChange = new OutputFileChange(fileName, ChangeType.ADDED);
        }

        @Override
        public void removed(String fileName) {
            this.lastChange = new OutputFileChange(fileName, ChangeType.REMOVED);
        }

        @Override
        public void changed(String fileName) {
            this.lastChange = new OutputFileChange(fileName, ChangeType.MODIFIED);
        }
    }
}

