/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.collections.collection.CompositeCollection;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.Actions;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDomainObjectSet<T>
extends DefaultDomainObjectSet<T> {
    private Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private Spec<T> notInSpec = new ItemNotInCompositeSpec();

    public CompositeDomainObjectSet(Class<T> type) {
        super(type, new CompositeCollection());
    }

    public CompositeDomainObjectSet(Class<T> type, DomainObjectCollection<? extends T> ... collections) {
        this((Class<? extends T>)type);
        for (DomainObjectCollection<? extends T> collection : collections) {
            this.addCollection(collection);
        }
    }

    protected CompositeCollection getStore() {
        return (CompositeCollection)super.getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(Actions.filter(action, this.uniqueSpec));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(Actions.filter(action, this.notInSpec));
    }

    public void addCollection(DomainObjectCollection<? extends T> collection) {
        if (!this.getStore().getCollections().contains(collection)) {
            this.getStore().addComposited(collection);
            collection.all(this.getEventRegister().getAddAction());
            collection.whenObjectRemoved(this.getEventRegister().getRemoveAction());
        }
    }

    public void removeCollection(DomainObjectCollection<? extends T> collection) {
        this.getStore().removeComposited(collection);
        Action action = this.getEventRegister().getRemoveAction();
        for (Object item : collection) {
            action.execute(item);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedHashSet(this.getStore()).iterator();
    }

    @Override
    public int size() {
        return new LinkedHashSet(this.getStore()).size();
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        for (T t : this) {
            action.execute(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemNotInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            return !CompositeDomainObjectSet.this.getStore().contains(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            int matches = 0;
            for (Object collection : CompositeDomainObjectSet.this.getStore().getCollections()) {
                if (!((Collection)collection).contains(element) || ++matches <= 1) continue;
                return false;
            }
            return true;
        }
    }
}

