/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.internal.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBufferingOutputStream
extends OutputStream {
    private boolean hasBeenClosed;
    private final byte[] lineSeparator;
    private final int bufferIncrement;
    private final Action<String> action;
    private byte[] buf;
    private int count;

    public LineBufferingOutputStream(Action<String> action) {
        this(action, 2048);
    }

    public LineBufferingOutputStream(Action<String> action, int bufferLength) {
        this.action = action;
        this.bufferIncrement = bufferLength;
        this.buf = new byte[bufferLength];
        this.count = 0;
        this.lineSeparator = SystemProperties.getLineSeparator().getBytes();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.hasBeenClosed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (this.count == this.buf.length) {
            int newBufLength = this.buf.length + this.bufferIncrement;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
        if (this.endsWithLineSeparator()) {
            this.flush();
        }
    }

    private boolean endsWithLineSeparator() {
        if (this.count < this.lineSeparator.length) {
            return false;
        }
        for (int i = 0; i < this.lineSeparator.length; ++i) {
            if (this.buf[this.count - this.lineSeparator.length + i] == this.lineSeparator[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void flush() {
        if (this.count != 0) {
            this.action.execute((Object)new String(this.buf, 0, this.count));
        }
        this.reset();
    }

    private void reset() {
        if (this.buf.length > this.bufferIncrement) {
            this.buf = new byte[this.bufferIncrement];
        }
        this.count = 0;
    }
}

