/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal;

import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.PropertyAccessor;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.model.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentModelObjectRegistry {
    private final BTreePersistentIndexedCache<Object, FlattenedObject> store;
    private final Map<Object, Object> idToInstance;
    private final Map<Object, Object> instanceToId;

    public PersistentModelObjectRegistry(File outputFile) {
        this.store = new BTreePersistentIndexedCache(outputFile, new DefaultSerializer(), new DefaultSerializer());
        this.idToInstance = new MapMaker().weakValues().makeMap();
        this.instanceToId = new MapMaker().weakKeys().makeMap();
    }

    public void put(Object identifier, Object modelObject) {
        if (modelObject.getClass().getAnnotation(ModelType.class) == null) {
            throw new IllegalArgumentException(String.format("Cannot persist object of class %s, as this class is not marked @%s", modelObject.getClass().getSimpleName(), ModelType.class.getSimpleName()));
        }
        FlattenedObject flattened = new FlattenedObject();
        Class<?> type = modelObject.getClass();
        for (PropertyAccessor property : JavaReflectionUtil.readableProperties(type).values()) {
            Object value;
            if (property.getName().equals("metaClass") || property.getName().equals("class")) continue;
            try {
                value = property.getValue(modelObject);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not get property %s for model %s (%s)", property.getName(), identifier, modelObject.getClass().getSimpleName()), (Throwable)e);
            }
            if (value != null && value.getClass().getAnnotation(ModelType.class) != null) {
                Object valueId = this.instanceToId.get(value);
                if (valueId == null) {
                    throw new IllegalStateException(String.format("Model %s (%s) references an unknown model object of type %s.", identifier, modelObject.getClass().getSimpleName(), value.getClass().getSimpleName()));
                }
                value = new Reference(value.getClass().getName(), valueId);
            }
            flattened.properties.put(property.getName(), value);
        }
        this.idToInstance.put(identifier, modelObject);
        this.instanceToId.put(modelObject, identifier);
        this.store.put(identifier, flattened);
    }

    @Nullable
    public <T> T get(Object identifier, Class<T> type) {
        Object modelObject = this.idToInstance.get(identifier);
        if (modelObject != null) {
            return type.cast(modelObject);
        }
        FlattenedObject flattened = this.store.get(identifier);
        if (flattened == null) {
            return null;
        }
        try {
            modelObject = type.newInstance();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create an instance of %s.", type.getSimpleName()), (Throwable)e);
        }
        for (Map.Entry<String, Object> entry : flattened.properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Reference) {
                Class<?> referenceType;
                Reference reference = (Reference)value;
                try {
                    referenceType = type.getClassLoader().loadClass(reference.type);
                }
                catch (ClassNotFoundException e) {
                    throw new GradleException(String.format("Could not locate type %s referenced by model %s (%s)", reference.type, identifier, type.getSimpleName()));
                }
                value = this.get(reference.identifier, referenceType);
            }
            try {
                JavaReflectionUtil.writeableProperty(modelObject.getClass(), (String)entry.getKey()).setValue(modelObject, value);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not set property %s for model %s (%s)", entry.getKey(), identifier, type.getSimpleName()), (Throwable)e);
            }
        }
        this.idToInstance.put(identifier, modelObject);
        this.instanceToId.put(modelObject, identifier);
        return type.cast(modelObject);
    }

    public void close() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.store}).stop();
    }

    private static class FlattenedObject
    implements Serializable {
        Map<String, Object> properties = new TreeMap<String, Object>();

        private FlattenedObject() {
        }
    }

    private static class Reference
    implements Serializable {
        final String type;
        final Object identifier;

        private Reference(String type, Object identifier) {
            this.type = type;
            this.identifier = identifier;
        }
    }
}

