/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import org.gradle.StartParameter;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.DefaultTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ShortCircuitTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.state.CacheBackedFileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.CacheBackedTaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.CachingHasher;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.state.DefaultHasher;
import org.gradle.api.internal.changedetection.state.DefaultTaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteAtMostOnceTaskExecuter;
import org.gradle.api.internal.tasks.execution.PostExecutionAnalysisTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipEmptySourceFilesTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipOnlyIfTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipTaskWithNoActionsExecuter;
import org.gradle.api.internal.tasks.execution.SkipUpToDateTaskExecuter;
import org.gradle.api.internal.tasks.execution.ValidatingTaskExecuter;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.listener.ListenerManager;

public class TaskExecutionServices
extends DefaultServiceRegistry {
    private final Gradle gradle;

    public TaskExecutionServices(ServiceRegistry parent, Gradle gradle) {
        super(parent);
        this.gradle = gradle;
    }

    protected TaskExecuter createTaskExecuter() {
        TaskArtifactStateCacheAccess cacheAccess = (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class);
        TaskArtifactStateRepository repository = (TaskArtifactStateRepository)this.get(TaskArtifactStateRepository.class);
        return new ExecuteAtMostOnceTaskExecuter(new SkipOnlyIfTaskExecuter(new SkipTaskWithNoActionsExecuter(new SkipEmptySourceFilesTaskExecuter(new ValidatingTaskExecuter(new SkipUpToDateTaskExecuter(repository, new PostExecutionAnalysisTaskExecuter(new ExecuteActionsTaskExecuter(((ListenerManager)this.get(ListenerManager.class)).getBroadcaster(TaskActionListener.class)))))))));
    }

    protected TaskArtifactStateCacheAccess createCacheAccess() {
        return new DefaultTaskArtifactStateCacheAccess(this.gradle, (CacheRepository)this.get(CacheRepository.class));
    }

    protected TaskArtifactStateRepository createTaskArtifactStateRepository() {
        TaskArtifactStateCacheAccess cacheAccess = (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class);
        DefaultFileSnapshotter fileSnapshotter = new DefaultFileSnapshotter(new CachingHasher(new DefaultHasher(), cacheAccess), cacheAccess);
        OutputFilesSnapshotter outputFilesSnapshotter = new OutputFilesSnapshotter(fileSnapshotter, (IdGenerator<Long>)new RandomLongIdGenerator(), cacheAccess);
        CacheBackedTaskHistoryRepository taskHistoryRepository = new CacheBackedTaskHistoryRepository(cacheAccess, new CacheBackedFileSnapshotRepository(cacheAccess, (IdGenerator<Long>)new RandomLongIdGenerator()));
        Instantiator instantiator = (Instantiator)this.get(Instantiator.class);
        return new ShortCircuitTaskArtifactStateRepository((StartParameter)this.get(StartParameter.class), instantiator, new DefaultTaskArtifactStateRepository(taskHistoryRepository, instantiator, outputFilesSnapshotter, fileSnapshotter));
    }

    protected TaskPlanExecutor createTaskExecutorFactory() {
        StartParameter startParameter = this.gradle.getStartParameter();
        TaskArtifactStateCacheAccess cacheAccess = (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class);
        return new TaskPlanExecutorFactory(cacheAccess, startParameter.getParallelThreadCount()).create();
    }
}

