/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.Arrays;
import java.util.LinkedList;
import org.gradle.StartParameter;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.plugins.DefaultPluginContainer;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.DefaultProjectRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.DefaultBuildExecuter;
import org.gradle.execution.DefaultTasksBuildExecutionAction;
import org.gradle.execution.DryRunBuildExecutionAction;
import org.gradle.execution.ExcludedTaskFilteringBuildConfigurationAction;
import org.gradle.execution.ProjectEvaluatingAction;
import org.gradle.execution.SelectedTaskExecutionAction;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.TaskNameResolvingBuildConfigurationAction;
import org.gradle.execution.taskgraph.DefaultTaskGraphExecuter;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ProjectScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.service.scopes.TaskExecutionServices;
import org.gradle.invocation.BuildClassLoaderRegistry;
import org.gradle.listener.ListenerManager;

public class GradleScopeServices
extends DefaultServiceRegistry
implements ServiceRegistryFactory {
    private final GradleInternal gradle;

    public GradleScopeServices(ServiceRegistry parent, GradleInternal gradle) {
        super(parent);
        this.gradle = gradle;
        this.add((ServiceRegistry)new TaskExecutionServices(parent, gradle));
    }

    protected BuildExecuter createBuildExecuter() {
        LinkedList<BuildConfigurationAction> configs = new LinkedList<BuildConfigurationAction>();
        if (((StartParameter)this.get(StartParameter.class)).isConfigureOnDemand()) {
            configs.add(new ProjectEvaluatingAction());
        }
        configs.add(new DefaultTasksBuildExecutionAction());
        configs.add(new ExcludedTaskFilteringBuildConfigurationAction());
        configs.add(new TaskNameResolvingBuildConfigurationAction());
        return new DefaultBuildExecuter(configs, Arrays.asList(new DryRunBuildExecutionAction(), new SelectedTaskExecutionAction()));
    }

    protected ProjectFinder createProjectFinder() {
        return new ProjectFinder(){

            public ProjectInternal getProject(String path) {
                return GradleScopeServices.this.gradle.getRootProject().project(path);
            }
        };
    }

    protected ProjectRegistry createIProjectRegistry() {
        return new DefaultProjectRegistry();
    }

    protected TaskGraphExecuter createTaskGraphExecuter() {
        return new DefaultTaskGraphExecuter((ListenerManager)this.get(ListenerManager.class), (TaskPlanExecutor)this.get(TaskPlanExecutor.class));
    }

    public ServiceRegistryFactory createFor(Object domainObject) {
        if (domainObject instanceof ProjectInternal) {
            return new ProjectScopeServices(this, (ProjectInternal)domainObject);
        }
        throw new UnsupportedOperationException();
    }

    protected PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild(((BuildClassLoaderRegistry)this.get(BuildClassLoaderRegistry.class)).getScriptClassLoader(), new DependencyInjectingInstantiator(this));
    }

    protected PluginContainer createPluginContainer() {
        return new DefaultPluginContainer<GradleInternal>((PluginRegistry)this.get(PluginRegistry.class), this.gradle);
    }
}

