/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.Jvm;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final FilteringClassLoader rootClassLoader;
    private final ClassLoader coreImplClassLoader;
    private final ClassLoader pluginsClassLoader;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            ClassLoader systemClassLoaderParent = ClassLoader.getSystemClassLoader().getParent();
            ClasspathUtil.addUrl((URLClassLoader)((URLClassLoader)systemClassLoaderParent), (Iterable)new DefaultClassPath(new File[]{toolsJar}).getAsURLs());
        }
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        ClassPath coreImplClassPath = classPathRegistry.getClassPath("GRADLE_CORE_IMPL");
        this.coreImplClassLoader = new MutableURLClassLoader(runtimeClassLoader, coreImplClassPath);
        ClassPath pluginsClassPath = classPathRegistry.getClassPath("GRADLE_PLUGINS");
        CachingClassLoader pluginsImports = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{runtimeClassLoader, this.coreImplClassLoader}));
        this.pluginsClassLoader = new MutableURLClassLoader((ClassLoader)pluginsImports, pluginsClassPath);
        this.rootClassLoader = classLoaderFactory.createFilteringClassLoader(this.pluginsClassLoader);
        this.rootClassLoader.allowPackage("org.gradle");
        this.rootClassLoader.allowResources("META-INF/gradle-plugins");
        this.rootClassLoader.allowPackage("org.apache.tools.ant");
        this.rootClassLoader.allowPackage("groovy");
        this.rootClassLoader.allowPackage("org.codehaus.groovy");
        this.rootClassLoader.allowPackage("groovyjarjarantlr");
        this.rootClassLoader.allowPackage("org.apache.ivy");
        this.rootClassLoader.allowPackage("org.slf4j");
        this.rootClassLoader.allowPackage("org.apache.commons.logging");
        this.rootClassLoader.allowPackage("org.apache.log4j");
        this.rootClassLoader.allowPackage("javax.inject");
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getGradleApiClassLoader() {
        return this.rootClassLoader;
    }

    public ClassLoader getCoreImplClassLoader() {
        return this.coreImplClassLoader;
    }

    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }
}

