/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import java.io.File;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.resource.Resource;
import org.gradle.api.internal.resource.UriResource;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.hash.HashUtil;

public class UriScriptSource
implements ScriptSource {
    private final Resource resource;
    private String className;

    public UriScriptSource(String description, File sourceFile) {
        this.resource = new UriResource(description, sourceFile);
    }

    public UriScriptSource(String description, URI sourceUri) {
        this.resource = new UriResource(description, sourceUri);
    }

    public String getClassName() {
        if (this.className == null) {
            URI sourceUri = this.resource.getURI();
            String name = StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)sourceUri.toString(), (String)"/"), (String)".");
            StringBuilder className = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isJavaIdentifierPart(ch)) {
                    className.append(ch);
                    continue;
                }
                className.append('_');
            }
            if (!Character.isJavaIdentifierStart(className.charAt(0))) {
                className.insert(0, '_');
            }
            className.setLength(Math.min(className.length(), 30));
            className.append('_');
            String path = sourceUri.toString();
            className.append(HashUtil.createCompactMD5((String)path));
            this.className = className.toString();
        }
        return this.className;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getFileName() {
        File sourceFile = this.resource.getFile();
        URI sourceUri = this.resource.getURI();
        return sourceFile != null ? sourceFile.getPath() : sourceUri.toString();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }
}

