/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.CommandLineOption;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ParsedCommandLineOption;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineTaskConfigurer {
    public List<String> configureTasks(Collection<Task> tasks, List<String> arguments) {
        assert (!tasks.isEmpty());
        if (arguments.isEmpty()) {
            return arguments;
        }
        return this.configureTasksNow(tasks, arguments);
    }

    private List<String> configureTasksNow(Collection<Task> tasks, List<String> arguments) {
        List remainingArguments = null;
        for (Task task : tasks) {
            ParsedCommandLine parsed;
            HashMap<String, JavaMethod> options = new HashMap<String, JavaMethod>();
            CommandLineParser parser = new CommandLineParser();
            for (Class<?> type = task.getClass(); type != Object.class; type = type.getSuperclass()) {
                for (Method method : type.getDeclaredMethods()) {
                    CommandLineOption commandLineOption = method.getAnnotation(CommandLineOption.class);
                    if (commandLineOption == null) continue;
                    String optionName = commandLineOption.options()[0];
                    org.gradle.cli.CommandLineOption option = parser.option(new String[]{optionName});
                    option.hasDescription(commandLineOption.description());
                    if (method.getParameterTypes().length > 0 && !this.hasSingleBooleanParameter(method)) {
                        option.hasArgument();
                    }
                    options.put(optionName, JavaReflectionUtil.method(Object.class, Object.class, (Method)method));
                }
            }
            try {
                parsed = parser.parse(arguments);
            }
            catch (CommandLineArgumentException e) {
                throw new GradleException("Problem configuring task " + task.getPath() + " from command line. " + e.getMessage(), (Throwable)e);
            }
            for (Map.Entry entry : options.entrySet()) {
                if (!parsed.hasOption((String)entry.getKey())) continue;
                ParsedCommandLineOption o = parsed.option((String)entry.getKey());
                if (o.hasValue()) {
                    ((JavaMethod)entry.getValue()).invoke((Object)task, new Object[]{o.getValue()});
                    continue;
                }
                ((JavaMethod)entry.getValue()).invoke((Object)task, new Object[]{true});
            }
            assert (remainingArguments == null || remainingArguments.equals(parsed.getExtraArguments())) : "we expect all options to be consumed by each task so remainingArguments should be the same for each task";
            remainingArguments = parsed.getExtraArguments();
        }
        return remainingArguments;
    }

    private boolean hasSingleBooleanParameter(Method method) {
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        Class<?> type = method.getParameterTypes()[0];
        return type == Boolean.class || type == Boolean.TYPE;
    }
}

