/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.cacheops;

import java.util.HashMap;
import java.util.Map;
import org.gradle.cache.internal.cacheops.CacheOperationStack;

public class CacheAccessOperationsStack {
    private final Map<Thread, CacheOperationStack> perThreadStacks = new HashMap<Thread, CacheOperationStack>();

    public void close() {
        this.perThreadStacks.remove(Thread.currentThread());
    }

    public void pushCacheAction(String operationDisplayName) {
        if (this.perThreadStacks.containsKey(Thread.currentThread())) {
            this.getCurrentStack().pushCacheAction(operationDisplayName);
        } else {
            this.perThreadStacks.put(Thread.currentThread(), new CacheOperationStack().pushCacheAction(operationDisplayName));
        }
    }

    public void popCacheAction(String operationDisplayName) {
        this.getCurrentStack().popCacheAction(operationDisplayName);
    }

    public boolean isInCacheAction() {
        return this.perThreadStacks.containsKey(Thread.currentThread()) && this.getCurrentStack().isInCacheAction();
    }

    public void pushLongRunningOperation(String operationDisplayName) {
        if (this.perThreadStacks.containsKey(Thread.currentThread())) {
            this.getCurrentStack().pushLongRunningOperation(operationDisplayName);
        } else {
            this.perThreadStacks.put(Thread.currentThread(), new CacheOperationStack().pushLongRunningOperation(operationDisplayName));
        }
    }

    public void popLongRunningOperation(String operationDisplayName) {
        this.getCurrentStack().popLongRunningOperation(operationDisplayName);
    }

    public String getDescription() {
        return this.getCurrentStack().getDescription();
    }

    private CacheOperationStack getCurrentStack() {
        if (!this.perThreadStacks.containsKey(Thread.currentThread())) {
            throw new IllegalStateException("operations stack not ready. Was push action invoked?");
        }
        return this.perThreadStacks.get(Thread.currentThread());
    }

    public boolean maybeReentrantLongRunningOperation(String operationDisplayName) {
        boolean atLeastOneLongRunning = false;
        for (Thread thread : this.perThreadStacks.keySet()) {
            if (this.perThreadStacks.get(thread).isInCacheAction()) {
                return false;
            }
            if (!this.perThreadStacks.get(thread).isInLongRunningOperation()) continue;
            atLeastOneLongRunning = true;
        }
        if (atLeastOneLongRunning) {
            this.pushLongRunningOperation(operationDisplayName);
            return true;
        }
        return false;
    }
}

