/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileIntegrityViolationException;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.InsufficientLockModeException;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.ProcessMetaDataProvider;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Factory;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileLockManager
implements FileLockManager {
    private static final Logger LOGGER = Logging.getLogger(DefaultFileLockManager.class);
    private static final int DEFAULT_LOCK_TIMEOUT = 60000;
    private static final byte STATE_REGION_PROTOCOL = 1;
    private static final int STATE_REGION_SIZE = 2;
    private static final int STATE_REGION_POS = 0;
    private static final byte INFORMATION_REGION_PROTOCOL = 3;
    private static final int INFORMATION_REGION_POS = 2;
    public static final int INFORMATION_REGION_SIZE = 2052;
    public static final int INFORMATION_REGION_DESCR_CHUNK_LIMIT = 340;
    private final Set<File> lockedFiles = new CopyOnWriteArraySet<File>();
    private final ProcessMetaDataProvider metaDataProvider;
    private final int lockTimeoutMs;
    private final IdGenerator<Long> generator;
    private FileLockContentionHandler fileLockContentionHandler;
    private final long shortTimeoutMs = 10000L;

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, FileLockContentionHandler fileLockContentionHandler) {
        this(metaDataProvider, 60000, fileLockContentionHandler);
    }

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs, FileLockContentionHandler fileLockContentionHandler) {
        this(metaDataProvider, lockTimeoutMs, fileLockContentionHandler, (IdGenerator<Long>)new RandomLongIdGenerator());
    }

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs, FileLockContentionHandler fileLockContentionHandler, IdGenerator<Long> generator) {
        this.metaDataProvider = metaDataProvider;
        this.lockTimeoutMs = lockTimeoutMs;
        this.fileLockContentionHandler = fileLockContentionHandler;
        this.generator = generator;
    }

    @Override
    public FileLock lock(File target, FileLockManager.LockMode mode, String targetDisplayName) throws LockTimeoutException {
        return this.lock(target, mode, targetDisplayName, "");
    }

    @Override
    public FileLock lock(File target, FileLockManager.LockMode mode, String targetDisplayName, String operationDisplayName) {
        if (mode == FileLockManager.LockMode.None) {
            throw new UnsupportedOperationException(String.format("No %s mode lock implementation available.", new Object[]{mode}));
        }
        File canonicalTarget = GFileUtils.canonicalise(target);
        if (!this.lockedFiles.add(canonicalTarget)) {
            throw new IllegalStateException(String.format("Cannot lock %s as it has already been locked by this process.", targetDisplayName));
        }
        try {
            int port = this.fileLockContentionHandler.reservePort();
            return new DefaultFileLock(canonicalTarget, mode, targetDisplayName, operationDisplayName, port);
        }
        catch (Throwable t) {
            this.lockedFiles.remove(canonicalTarget);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    @Override
    public void allowContention(FileLock fileLock, Runnable whenContended) {
        this.fileLockContentionHandler.start(fileLock.getLockId(), whenContended);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultFileLock
    extends AbstractFileAccess
    implements FileLock {
        private final File lockFile;
        private final File target;
        private final FileLockManager.LockMode mode;
        private final String displayName;
        private final String operationDisplayName;
        private java.nio.channels.FileLock lock;
        private RandomAccessFile lockFileAccess;
        private boolean integrityViolated;
        private int port;
        private final long lockId;

        public DefaultFileLock(File target, FileLockManager.LockMode mode, String displayName, String operationDisplayName, int port) throws Throwable {
            this.port = port;
            this.lockId = (Long)DefaultFileLockManager.this.generator.generateId();
            if (mode == FileLockManager.LockMode.None) {
                throw new UnsupportedOperationException("Locking mode None is not supported.");
            }
            this.target = target;
            this.displayName = displayName;
            this.operationDisplayName = operationDisplayName;
            this.lockFile = target.isDirectory() ? new File(target, target.getName() + ".lock") : new File(target.getParentFile(), target.getName() + ".lock");
            GFileUtils.mkdirs(this.lockFile.getParentFile());
            this.lockFile.createNewFile();
            this.lockFileAccess = new RandomAccessFile(this.lockFile, "rw");
            try {
                this.lock = this.lock(mode);
                this.integrityViolated = !this.getUnlockedCleanly();
            }
            catch (Throwable t) {
                this.lockFileAccess.close();
                throw t;
            }
            this.mode = this.lock.isShared() ? FileLockManager.LockMode.Shared : FileLockManager.LockMode.Exclusive;
        }

        @Override
        public boolean isLockFile(File file) {
            return file.equals(this.lockFile);
        }

        @Override
        public boolean getUnlockedCleanly() {
            this.assertOpen();
            try {
                this.lockFileAccess.seek(1L);
                if (!this.lockFileAccess.readBoolean()) {
                    return false;
                }
            }
            catch (EOFException e) {
                return false;
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            return true;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            return (T)action.create();
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            this.doWriteAction(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            this.assertOpen();
            this.doWriteAction(action);
        }

        private void doWriteAction(Runnable action) {
            if (this.mode != FileLockManager.LockMode.Exclusive) {
                throw new InsufficientLockModeException("An exclusive lock is required for this operation");
            }
            try {
                this.integrityViolated = true;
                this.markDirty();
                action.run();
                this.markClean();
                this.integrityViolated = false;
            }
            catch (Throwable t) {
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
        }

        private void assertOpen() {
            if (this.lock == null) {
                throw new IllegalStateException("This lock has been closed.");
            }
        }

        private void assertOpenAndIntegral() {
            this.assertOpen();
            if (this.integrityViolated) {
                throw new FileIntegrityViolationException(String.format("The file '%s' was not unlocked cleanly", this.target));
            }
        }

        private void markClean() throws IOException {
            this.lockFileAccess.seek(0L);
            this.lockFileAccess.writeByte(1);
            this.lockFileAccess.writeBoolean(true);
            assert (this.lockFileAccess.getFilePointer() == 2L);
        }

        private void markDirty() throws IOException {
            this.lockFileAccess.seek(0L);
            this.lockFileAccess.writeByte(1);
            this.lockFileAccess.writeBoolean(false);
            assert (this.lockFileAccess.getFilePointer() == 2L);
        }

        @Override
        public void close() {
            CompositeStoppable stoppable = new CompositeStoppable();
            stoppable.add(new Object[]{new Stoppable(){

                public void stop() {
                    try {
                        DefaultFileLockManager.this.fileLockContentionHandler.stop(DefaultFileLock.this.lockId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to stop listening for file lock requests for " + DefaultFileLock.this.displayName, e);
                    }
                }
            }});
            stoppable.add(new Object[]{new Stoppable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stop() {
                    block11: {
                        if (DefaultFileLock.this.lockFileAccess == null) {
                            return;
                        }
                        try {
                            LOGGER.debug("Releasing lock on {}.", DefaultFileLock.this.displayName);
                            try {
                                java.nio.channels.FileLock info;
                                if (DefaultFileLock.this.lock == null || DefaultFileLock.this.lock.isShared()) break block11;
                                try {
                                    info = DefaultFileLock.this.lockInformationRegion(FileLockManager.LockMode.Exclusive, System.currentTimeMillis() + 10000L);
                                }
                                catch (InterruptedException e) {
                                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                                }
                                if (info == null) break block11;
                                try {
                                    DefaultFileLock.this.lockFileAccess.setLength(2L);
                                }
                                finally {
                                    info.release();
                                }
                            }
                            finally {
                                DefaultFileLock.this.lockFileAccess.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to release lock on " + DefaultFileLock.this.displayName, e);
                        }
                    }
                }
            }});
            stoppable.add(new Object[]{new Stoppable(){

                public void stop() {
                    DefaultFileLock.this.lock = null;
                    DefaultFileLock.this.lockFileAccess = null;
                    DefaultFileLockManager.this.lockedFiles.remove(DefaultFileLock.this.target);
                }
            }});
            stoppable.stop();
        }

        @Override
        public FileLockManager.LockMode getMode() {
            return this.mode;
        }

        @Override
        public long getLockId() {
            return this.lockId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private java.nio.channels.FileLock lock(FileLockManager.LockMode lockMode) throws Throwable {
            java.nio.channels.FileLock stateRegionLock;
            block10: {
                LOGGER.debug("Waiting to acquire {} lock on {}.", lockMode.toString().toLowerCase(), this.displayName);
                long waitUntil = System.currentTimeMillis() + (long)DefaultFileLockManager.this.lockTimeoutMs;
                stateRegionLock = this.lockStateRegion(lockMode, waitUntil);
                if (stateRegionLock == null) {
                    OwnerInfo ownerInfo = this.readInformationRegion(System.currentTimeMillis() + 10000L);
                    throw new LockTimeoutException(String.format("Timeout waiting to lock %s. It is currently in use by another Gradle instance.%nOwner PID: %s%nOur PID: %s%nOwner Operation: %s%nOur operation: %s%nLock file: %s", this.displayName, ownerInfo.pid, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), ownerInfo.operation, this.operationDisplayName, this.lockFile));
                }
                try {
                    java.nio.channels.FileLock informationRegionLock;
                    if (this.lockFileAccess.length() > 0L) {
                        this.lockFileAccess.seek(0L);
                        if (this.lockFileAccess.readByte() != 1) {
                            throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file '%s' for %s.", this.lockFile, this.displayName));
                        }
                    }
                    if (stateRegionLock.isShared()) break block10;
                    if (this.lockFileAccess.length() < 2L) {
                        this.lockFileAccess.seek(0L);
                        this.lockFileAccess.writeByte(1);
                        this.lockFileAccess.writeBoolean(false);
                    }
                    if ((informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, System.currentTimeMillis() + 10000L)) == null) {
                        throw new IllegalStateException(String.format("Unable to lock the information region for %s", this.displayName));
                    }
                    try {
                        this.lockFileAccess.seek(2L);
                        this.lockFileAccess.writeByte(3);
                        this.lockFileAccess.writeInt(this.port);
                        this.lockFileAccess.writeLong(this.lockId);
                        this.lockFileAccess.writeUTF(this.trimIfNecessary(DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier()));
                        this.lockFileAccess.writeUTF(this.trimIfNecessary(this.operationDisplayName));
                        this.lockFileAccess.setLength(this.lockFileAccess.getFilePointer());
                    }
                    finally {
                        informationRegionLock.release();
                    }
                }
                catch (Throwable t) {
                    stateRegionLock.release();
                    throw t;
                }
            }
            LOGGER.debug("Lock acquired.");
            return stateRegionLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OwnerInfo readInformationRegion(long waitUntil) throws IOException, InterruptedException {
            OwnerInfo out = new OwnerInfo();
            out.pid = "unknown";
            out.operation = "unknown";
            out.port = -1;
            java.nio.channels.FileLock informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Shared, waitUntil);
            if (informationRegionLock == null) {
                LOGGER.debug("Could not lock information region for {}. Ignoring.", this.displayName);
            } else {
                try {
                    if (this.lockFileAccess.length() <= 2L) {
                        LOGGER.debug("Lock file for {} is too short to contain information region. Ignoring.", this.displayName);
                    } else {
                        this.lockFileAccess.seek(2L);
                        if (this.lockFileAccess.readByte() != 3) {
                            throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file '%s' for %s.", this.lockFile, this.displayName));
                        }
                        out.port = this.lockFileAccess.readInt();
                        out.lockId = this.lockFileAccess.readLong();
                        out.pid = this.lockFileAccess.readUTF();
                        out.operation = this.lockFileAccess.readUTF();
                        LOGGER.debug("Read following information from the file lock info region. Port: {}, owner: {}, operation: {}", out.port, out.pid, out.operation);
                    }
                }
                finally {
                    informationRegionLock.release();
                }
            }
            return out;
        }

        private String trimIfNecessary(String inputString) {
            if (inputString.length() > 340) {
                return inputString.substring(0, 340);
            }
            return inputString;
        }

        private java.nio.channels.FileLock lockStateRegion(FileLockManager.LockMode lockMode, long waitUntil) throws IOException, InterruptedException {
            do {
                java.nio.channels.FileLock fileLock;
                if ((fileLock = this.lockRegion(lockMode, 0L, 2L)) != null) {
                    return fileLock;
                }
                if (this.port != -1) {
                    OwnerInfo ownerInfo = this.readInformationRegion(System.currentTimeMillis());
                    if (ownerInfo.port != -1) {
                        LOGGER.debug("The file lock is held by a different Gradle process (pid: {}, operation: {}). Will attempt to ping owner at port {}", ownerInfo.pid, ownerInfo.operation, ownerInfo.port);
                        DefaultFileLockManager.this.fileLockContentionHandler.pingOwner(ownerInfo.port, ownerInfo.lockId, this.displayName);
                    } else {
                        LOGGER.debug("The file lock is held by a different Gradle process. I was unable to read on which port the owner listens for lock access requests.");
                    }
                }
                Thread.sleep(200L);
            } while (System.currentTimeMillis() < waitUntil);
            return null;
        }

        private java.nio.channels.FileLock lockInformationRegion(FileLockManager.LockMode lockMode, long waitUntil) throws IOException, InterruptedException {
            do {
                java.nio.channels.FileLock fileLock;
                if ((fileLock = this.lockRegion(lockMode, 2L, 2050L)) != null) {
                    return fileLock;
                }
                Thread.sleep(200L);
            } while (System.currentTimeMillis() < waitUntil);
            return null;
        }

        private java.nio.channels.FileLock lockRegion(FileLockManager.LockMode lockMode, long start, long size) throws IOException, InterruptedException {
            return this.lockFileAccess.getChannel().tryLock(start, size, lockMode == FileLockManager.LockMode.Shared);
        }
    }

    private class OwnerInfo {
        int port;
        long lockId;
        String pid;
        String operation;

        private OwnerInfo() {
        }
    }
}

